% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_combine.r
\name{html_combine}
\alias{html_combine}
\title{Combines multiple HTML files to a single tex and compiles document}
\usage{
html_combine(
  combine = ".",
  out = NULL,
  toctheme = TRUE,
  css = paste0(system.file(package = "R3port"), "/style.css"),
  clean = 0,
  ...
)
}
\arguments{
\item{combine}{character string with the location of the raw html files or list with file names within same directory}

\item{out}{filename for the output HTML file (if NULL it will print to console)}

\item{toctheme}{logical indicating if the created file should also have a toc (take into account for template)}

\item{css}{character with name of the css style sheet to use, default use package style sheet}

\item{clean}{integer between 0 and 2 indicating if all individual files should be kept (0), all individual raw html files should
be deleted (1) or all individual files should be deleted (2)}

\item{...}{additional arguments passed through to \code{\link[=html_doc]{html_doc()}}. Most important are template, rendlist, css and show}
}
\value{
The function returns a HTML file (or writes output to console)
}
\description{
This function combines multiple HTML files. This is done based on the name of the files and should
end with raw.tex to make the function pick-up these files.
}
\details{
Currently the generated output is saved in the same place where the separate tables and plots are located
defined in the 'combine' argument. This is done even when a different file path is specified in 'out' (using the basename function).
The reason is to not copy files linked within the document and preventing broken links. This behaviour might change in future releases
}
\examples{

# Take into account the usage of tempfile() with multiple function calls
data(Theoph)
html_list(Theoph[1:11,],out=tempfile(fileext=".html"),show=FALSE)
html_plot(plot(conc~Time,data=Theoph),out=tempfile(fileext=".html"),show=FALSE)
\dontrun{
  html_combine(combine=tempdir(),out="rep1.html")

  # toctheme can be used to have a clickable toc,
  # a bootstrap template for this is provided in the package
  html_combine(combine=tempdir(),out="rep1.html",
              template=paste0(system.file(package="R3port"),"/bootstrap.html"),
              toctheme=TRUE)
 }
}
