% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_scenarios.R
\name{simulate_scenarios}
\alias{simulate_scenarios}
\title{Simulate multiple scenarios of household lifetime finances}
\usage{
simulate_scenarios(
  scenarios_parameters,
  household,
  portfolio,
  current_date = get_current_date(),
  monte_carlo_samples = NULL,
  auto_parallel = FALSE,
  use_cache = FALSE,
  debug = FALSE,
  ...
)
}
\arguments{
\item{scenarios_parameters}{A \code{tibble} with column
\code{scenario_id} and nested column \code{events}.
Each scenario has defined one or more events in the tibbles
that are stored in as a list in the \code{events} column.}

\item{household}{An R6 object of class \code{Household}.}

\item{portfolio}{A nested \code{tibble} of class \code{Portfolio}.}

\item{current_date}{A character. Current date in the format \code{YYYY-MM-DD}.
By default, it is the output of \code{\link[=get_current_date]{get_current_date()}}.}

\item{monte_carlo_samples}{An integer. Number of Monte Carlo samples.
If \code{NULL} (default), no Monte Carlo samples are generated.}

\item{auto_parallel}{A logical. If \code{TRUE}, the function
automatically detects the number of cores and uses parallel processing
to speed up the Monte Carlo simulations.
The results are cached in the folder set by \code{\link[=set_cache]{set_cache()}}.}

\item{use_cache}{A logical. If \code{TRUE}, the function uses memoised functions
to speed up the simulation. The results are cached in the folder
set by \code{\link[=set_cache]{set_cache()}}.}

\item{debug}{A logical. If \code{TRUE}, additional information is printed
during the simulation.}

\item{...}{Additional arguments passed simulation functions.}
}
\value{
A \code{tibble} with nested columns.
}
\description{
Simulate multiple scenarios of household lifetime finances
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
older_member <- HouseholdMember$new(
  name       = "older",  
  birth_date = "1980-02-15",
  mode       = 80,
  dispersion = 10
)  
household <- Household$new()
household$add_member(older_member)  

household$expected_income <- list(
  "income" = c(
    "members$older$age <= 65 ~ 7000 * 12"
  )
)
household$expected_spending <- list(
  "spending" = c(
    "TRUE ~ 5000 * 12"
  )
)

portfolio <- create_portfolio_template() 
portfolio$accounts$taxable <- c(10000, 30000)
portfolio <- 
  portfolio |> 
  calc_effective_tax_rate(
    tax_rate_ltcg = 0.20, 
    tax_rate_ordinary_income = 0.40
  )
start_ages <- c(60, 65, 70)
scenarios_parameters <- 
  tibble::tibble(
    member    = "older",
    event      = "retirement",
    start_age = start_ages,
    years     = Inf,
    end_age   = Inf
   ) |> 
  dplyr::mutate(scenario_id = start_age) |> 
  tidyr::nest(events = -scenario_id)

scenarios_parameters

scenarios <- 
  simulate_scenarios(
    scenarios_parameters = scenarios_parameters,
    household            = household,
    portfolio            = portfolio,
    current_date         = "2020-07-15"
  )
scenarios$scenario_id |> unique()
\dontshow{\}) # examplesIf}
}
