% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{stig_from_ig_stable_dist}
\alias{stig_from_ig_stable_dist}
\title{Symmetric Target Information Gain (STIG) computed from single Information Gains (IGs) but with pre-computed 1D conditional entropy (aka stable)}
\usage{
stig_from_ig_stable_dist(relevant_train_data, train_decision, seed)
}
\arguments{
\item{relevant_train_data}{input data where columns are variables and rows are observations (all numeric); assumed to contain only relevant data}

\item{train_decision}{decision variable as a binary sequence of length equal to number of observations}

\item{seed}{a numerical seed}
}
\value{
A matrix of distances (dissimilarities).
}
\description{
To be used as one of the \code{dist_funs} in \code{\link{run_rafs}}.
}
\details{
This function computes the STIG metric from single Information Gains (IGs) maximised over 30 discretisations and then summed pair-wise, but reusing
the common 1D conditional entropy.

It tends to work similarly to \code{\link{stig_stable_dist}}.
}
