% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_rag_chain.R
\name{create_rag_chain}
\alias{create_rag_chain}
\title{create_rag_chain.R Overview}
\arguments{
\item{llm}{A function that takes a prompt and returns a response (e.g. a call to OpenAI or Claude).}

\item{vector_database_directory}{Path to the DuckDB database file.}

\item{method}{Retrieval method backend. Currently only `"DuckDB"` is supported.}

\item{embedding_function}{A function to embed text. Defaults to \code{embed_openai()}.}

\item{system_prompt}{Optional prompt with placeholders \code{{chat_history}}, \code{{input}}, \code{{context}}.}

\item{chat_history_prompt}{Prompt used to rephrase follow-up questions using prior conversation history.}

\item{tavily_search}{Tavily API key (set to \code{NULL} to disable web search).}

\item{embedding_dim}{Integer; embedding vector dimension. Defaults to \code{1536}.}

\item{use_web_search}{Logical; whether to include web results from Tavily. Defaults to \code{TRUE}.}
}
\value{
A list of utility functions:
\itemize{
  \item \code{invoke(text)} — Performs full context retrieval and LLM response
  \item \code{custom_invoke(text)} — Retrieves context only (no LLM call)
  \item \code{get_session_history()} — Returns complete conversation history
  \item \code{clear_history()} — Clears in-memory chat history
  \item \code{disconnect()} — Closes the underlying DuckDB connection
}
}
\description{
A refined implementation of a LangChain-style Retrieval-Augmented Generation (RAG) pipeline.
Includes vector search using DuckDB, optional web search using the Tavily API, and a
built-in chat message history.

This function powers `create_rag_chain()`, the exported entry point for constructing a full RAG pipeline.

## Features:
- Context-aware reformulation of user queries
- Semantic chunk retrieval using DuckDB
- Optional real-time web search (Tavily)
- Compatible with any LLM function (OpenAI, Claude, etc.)

## Required Packages
\code{install.packages(c("DBI", "duckdb", "httr", "jsonlite", "stringi", "dplyr"))}
}
\details{
Create a Retrieval-Augmented Generation (RAG) Chain

Creates a LangChain-style RAG chain using DuckDB for vector store operations, optional Tavily API for web search,
and in-memory message history for conversational context.
}
\note{
Only \code{create_rag_chain()} is exported. Helper functions are internal.
}
\examples{
\dontrun{
rag_chain <- create_rag_chain(
  llm = call_llm,
  vector_database_directory = "tests/testthat/test-data/my_vectors.duckdb",
  method = "DuckDB",
  embedding_function = embed_openai(),
  use_web_search = FALSE
)

response <- rag_chain$invoke("Tell me about R")
}

}
