% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_for_RGWAS.R
\name{score.calc.epistasis.LR}
\alias{score.calc.epistasis.LR}
\title{Calculate -log10(p) of epistatic effects by LR test}
\usage{
score.calc.epistasis.LR(
  M.now,
  y,
  X.now,
  ZETA.now,
  package.MM = "gaston",
  eigen.SGS = NULL,
  eigen.G = NULL,
  n.core = 1,
  optimizer = "nlminb",
  map,
  haplotype = TRUE,
  num.hap = NULL,
  window.size.half = 5,
  window.slide = 1,
  chi0.mixture = 0.5,
  gene.set = NULL,
  dominance.eff = TRUE,
  skip.self.int = FALSE,
  min.MAF = 0.02,
  count = TRUE
)
}
\arguments{
\item{M.now}{A \eqn{n \times m} genotype matrix where \eqn{n} is sample size and \eqn{m} is the number of markers.}

\item{y}{A \eqn{n \times 1} vector. A vector of phenotypic values should be used. NA is allowed.}

\item{X.now}{A \eqn{n \times p} matrix. You should assign mean vector (rep(1, n)) and covariates. NA is not allowed.}

\item{ZETA.now}{A list of variance (relationship) matrix (K; \eqn{m \times m}) and its design matrix (Z; \eqn{n \times m}) of random effects. You can use only one kernel matrix.
For example, ZETA = list(A = list(Z = Z, K = K))
Please set names of list "Z" and "K"!}

\item{package.MM}{The package name to be used when solving mixed-effects model. We only offer the following three packages: 
"RAINBOWR", "MM4LMM" and "gaston". Default package is `gaston`.
See more details at \code{\link{EM3.general}}.}

\item{eigen.SGS}{A list with
\describe{
\item{$values}{Eigen values}
\item{$vectors}{Eigen vectors}
}
The result of the eigen decompsition of \eqn{SGS}, where \eqn{S = I - X(X'X)^{-1}X'}, \eqn{G = ZKZ'}.
You can use "spectralG.cpp" function in RAINBOWR.
If this argument is NULL, the eigen decomposition will be performed in this function.
We recommend you assign the result of the eigen decomposition beforehand for time saving.}

\item{eigen.G}{A list with
\describe{
\item{$values}{Eigen values}
\item{$vectors}{Eigen vectors}
}
The result of the eigen decompsition of \eqn{G = ZKZ'}. You can use "spectralG.cpp" function in RAINBOWR.
If this argument is NULL, the eigen decomposition will be performed in this function.
We recommend you assign the result of the eigen decomposition beforehand for time saving.}

\item{n.core}{Setting n.core > 1 will enable parallel execution on a machine with multiple cores.}

\item{optimizer}{The function used in the optimization process. We offer "optim", "optimx", and "nlminb" functions.}

\item{map}{Data frame of map information where the first column is the marker names,
the second and third column is the chromosome amd map position, and the forth column is -log10(p) for each marker.}

\item{haplotype}{If the number of lines of your data is large (maybe > 100), you should set haplotype = TRUE.
When haplotype = TRUE, haplotype-based kernel will be used for calculating -log10(p).
(So the dimension of this gram matrix will be smaller.)
The result won't be changed, but the time for the calculation will be shorter.}

\item{num.hap}{When haplotype = TRUE, you can set the number of haplotypes which you expect.
Then similar arrays are considered as the same haplotype, and then make kernel(K.SNP) whose dimension is num.hap x num.hap.
When num.hap = NULL (default), num.hap will be set as the maximum number which reflects the difference between lines.}

\item{window.size.half}{This argument decides how many SNPs (around the SNP you want to test) are used to calculated K.SNP.
More precisely, the number of SNPs will be 2 * window.size.half + 1.}

\item{window.slide}{This argument determines how often you test markers. If window.slide = 1, every marker will be tested.
If you want to perform SNP set by bins, please set window.slide = 2 * window.size.half + 1.}

\item{chi0.mixture}{RAINBOWR assumes the tdeviance is considered to follow a x chisq(df = 0) + (1 - a) x chisq(df = r).
where r is the degree of freedom.
The argument chi0.mixture is a (0 <= a < 1), and default is 0.5.}

\item{gene.set}{If you have information of gene, you can use it to perform kernel-based GWAS.
You should assign your gene information to gene.set in the form of a "data.frame" (whose dimension is (the number of gene) x 2).
In the first column, you should assign the gene name. And in the second column, you should assign the names of each marker,
which correspond to the marker names of "geno" argument.}

\item{dominance.eff}{If this argument is TRUE, dominance effect is included in the model,
and additive x dominance and dominance x dominance are also tested as epistatic effects.
When you use inbred lines, please set this argument FALSE.}

\item{skip.self.int}{As default, the function also tests the self-interactions among the same SNP-sets.
If you want to avoid this, please set `skip.self.int = TRUE`.}

\item{min.MAF}{Specifies the minimum minor allele frequency (MAF).
If a marker has a MAF less than min.MAF, it is assigned a zero score.}

\item{count}{When count is TRUE, you can know how far RGWAS has ended with percent display.}
}
\value{
-log10(p) of epistatic effects for each SNP-set
}
\description{
Calculate -log10(p) of epistatic effects by LR test
}
\references{
Listgarten, J. et al. (2013) A powerful and efficient set test
 for genetic markers that handles confounders. Bioinformatics. 29(12): 1526-1533.

Lippert, C. et al. (2014) Greater power and computational efficiency for kernel-based
 association testing of sets of genetic variants. Bioinformatics. 30(22): 3206-3214.

Jiang, Y. and Reif, J.C. (2015) Modeling epistasis in genomic selection. Genetics. 201(2): 759-768.
}
