#' Physical map of rice genome
#'
#' @name Rice_haplo_block
#'
#' @description A dataset containing the information of haplotype block of rice genome (Zhao et al., 2010; PLoS One 5(5): e10780).
#' The haplotype blocks were estimated using PLINK 1.9 (See reference).
#'
#' @format A data frame with 74 rows and 2 variables:
#' \describe{
#'   \item{block}{names of haplotype blocks which consist of marker(s) in \link{Rice_geno_score}, character}
#'   \item{marker}{marker names for each marker corresponding to those in \link{Rice_geno_score}, character}
#' }
#' @source \url{http://www.ricediversity.org/data/}
#' @references
#' Zhao K, Wright M, Kimball J, Eizenga G, McClung A, Kovach M, Tyagi W, Ali ML, Tung CW, Reynolds A, Bustamante CD, McCouch SR (2010). Genomic Diversity and Introgression in O. sativa Reveal the Impact of Domestication and Breeding on the Rice Genome. PLoS One. 2010; 5(5): e10780.
#' Purcell, S. and Chang, C. (2018). PLINK 1.9, www.cog-genomics.org/plink/1.9/.
#' Chang CC, Chow CC, Tellier LCAM, Vattikuti S, Purcell SM, Lee JJ (2015) Second-generation PLINK: rising to the challenge of larger and richer datasets. GigaScience, 4.
#' Gaunt T, Rodríguez S, Day I (2007) Cubic exact solutions for the estimation of pairwise haplotype frequencies: implications for linkage disequilibrium analyses and a web tool 'CubeX'. BMC Bioinformatics, 8.
#' Taliun D, Gamper J, Pattaro C (2014) Efficient haplotype block recognition of very long and dense genetic sequences. BMC Bioinformatics, 15.
NULL
