% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeRCobjects.R
\name{mergeRCobjects}
\alias{mergeRCobjects}
\title{mergeRCobjects}
\usage{
mergeRCobjects(ramclustObj.1 = NULL, ramclustObj.2 = NULL,
  mztol = 0.02, rttol = 30, mzwt = 2, rtwt = 1)
}
\arguments{
\item{ramclustObj.1}{ramclustR object 1: this object will be the base for the new object.  That is all the features from ramclustObj.1 will be retained.}

\item{ramclustObj.2}{ramclustR object 2: this object will mapped and appended to racmlustObj1.  That is only features which appear consistent with those from ramclustObj.1 will be retained.}

\item{mztol}{numeric: absolute mass tolerance around mz}

\item{rttol}{numeric: feaure retention time tolerance.  Value set by this option will be used during the initial anchor mapping phase.  Two times the standard error of the rt loess correction will be used for the full mapping.}

\item{mzwt}{numeric: when mapping features, weighting value used for similarities between feature mass values (see rtwt)}

\item{rtwt}{numeric: when mapping features, weighting value used for similarities between feature retention time values (see mzwt)}
}
\value{
returns a ramclustR object.  All values from ramclustObj.1 are retained.  SpecAbund dataset from ramclustObj.1 is moved to RC$SpecAbund.1, where RC is the new ramclustObj.
}
\description{
merge two ramclustR objects
}
\details{
Two ramclustR objects are merged with this function, mapping features between them.  The first (ramclustObj.1) object use used as the template - all data in it is retained.  ramclustObj.2 is mapped to ramclustObj.1 feature by feature - only mapped features are retained.  A new ramlcustObj is returned, with a new SpecAbund dataset with the same column number as the ramclustObj.1$SpecAbund set.
}
\author{
Corey Broeckling
}
\concept{RAMClustR}
\concept{clustering}
\concept{feature}
\concept{mass spectrometry}
\concept{metabolomics}
\concept{ramclustR}
