% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AQSAPI_helperfunctions.R
\name{aqs_services_by_state}
\alias{aqs_services_by_state}
\title{aqs_services_by_state}
\usage{
aqs_services_by_state(
  parameter,
  bdate,
  edate,
  stateFIPS,
  service,
  cbdate = NA_Date_,
  cedate = NA_Date_
)
}
\arguments{
\item{parameter}{a character list or a single character string
which represents the parameter code of the air
pollutant related to the data being requested.}

\item{bdate}{a R date object which represents that begin date of the data
selection. Only data on or after this date will be returned.}

\item{edate}{a R date object which represents that end date of the data
selection. Only data on or before this date will be returned.}

\item{stateFIPS}{a R character object which represents the 2 digit state
FIPS code (with leading zero) for the state being
requested. @seealso \code{\link[=aqs_states]{aqs_states()}} for the list of
available FIPS codes.}

\item{service}{a string which represents the services provided by the
AQS API. For a list of available services @seealso
\url{https://aqs.epa.gov/aqsweb/documents/data_api.html#services}}

\item{cbdate}{a R date object which represents a "beginning
date of last change" that indicates when the data was last
updated. cbdate is used to filter data based on the change
date. Only data that changed on or after this date will be
returned. This is an optional variable which defaults
to NA_Date_.}

\item{cedate}{a R date object which represents an "end
date of last change" that indicates when the data was last
updated. cedate is used to filter data based on the change
date. Only data that changed on or before this date will be
returned. This is an optional variable which defaults
to NA_Date_.}
}
\value{
a AQS_DATAMART_APIv2 S3 object that is the return value from the
AQS API. A AQS_DATAMART_APIv2 is a 2 item named list in which the
first item ($Header) is a tibble of header information from the
AQS API and the second item ($Data) is a tibble of the data
returned.
}
\description{
a helper function that abstracts the formatting of the inputs
for a call to aqs away from the calling function for
aggregations by State then calls the aqs and returns the
result. This helper function is not meant to be called
directly from external functions.
}
