% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEU_simulation_main_GAUSSIAN.R
\name{SEU_simulation_main_GAUSSIAN}
\alias{SEU_simulation_main_GAUSSIAN}
\title{Sequential Estimation-adjusted Urn Model with Simulated Data (Gaussian
Responses)}
\usage{
SEU_simulation_main_GAUSSIAN(n, nstart, mu, sd, urn_comp, nstop,
 replication, group_allo, add_rule_index, add_rule,
 add_rule_full, sig_level)
}
\arguments{
\item{n}{The number of patients. The default is 500.}

\item{nstart}{Burn-in sample size of each arm. The default is n/20.}

\item{mu}{A vector of mean response for each treatment arm
(where the first element refers to the control arm).
The length of mu should correspond to the number of arms.
The default is mu = c(4.5,5).}

\item{sd}{A vector of response standard deviations for each treatment arm.
(where the first element refers to the control arm).
The length of sd should correspond to the number of arms.
The default is sd = c(1.32, 0.72).}

\item{urn_comp}{A vector of current urn composition. The default is NULL,
which indicates no ball in the urn.}

\item{nstop}{A vector of stopping cap of sample size for each arm. The trial
stops if at least one arm reaches the corresponding cap.
The default is NULL, which means no cap.}

\item{replication}{the number of replications of the simulation. The default
is 100.}

\item{group_allo}{A number or a vector of group size(s) for allocation.
If a number is given, the allocation ratios will be updated for each batch of
 group_allo samples. If a vector is given, the allocation ratios will be
 updated sequentially in group according to the vector.
 Any value greater than n will be omitted.
The default is group_allo=1, which is the same as group_allo = seq(nstart*length(p)+1,n).}

\item{add_rule_index}{Supply a number of 1 or 2 indicting the
addition rules to target allocation functions.
1 = the SEU model targeting Neyman allocation;
2 = the SEU model that assigns probability of 0.6+1/K to winner at each step.
The default is 1.}

\item{add_rule}{Supply a user-specified addition rules function of x.df and
arms when add_rule_index is NULL. Default is NULL. (See SEU_GAUSSIAN_raw for
details on x.df and arms.)}

\item{add_rule_full}{Indicator of reference data for updating addition rule.
If TRUE, the addition rule is updated by full observation at each group
allocation. If FALSE,the addition rule is updated by each group observation.
The default is TRUE.}

\item{sig_level}{Significant level (one-sided). The default is 0.05.}
}
\value{
\itemize{
  \item allocation_mean - Average of allocation in each arm based on `replication` repeats.
  \item allocation_sd - Standard deviation of allocation in each arm based on `replication` repeats.
  \item SS_mean - Average of sample size in each arm based on `replication` repeats.
  \item SS_sd - Standard deviation of sample size in each arm based on `replication` repeats.
  \item power_aov - Average power of ANOVA test.
  \item power_oneside - Average power for each of the k-th arm to perform one-sided Welch T-test against H0: mu_1>mu_k without multiplicity adjustment.
  \item mu_estimate_mean - Average of estimated response mean `mu`.
  \item sd_estimate_mean - Average of estimated response standard deviation `sd`.
  \item mu_estimate_sd - Standard deviation of estimated response mean `mu`.
  \item sd_estimate_sd - Standard deviation of estimated response standard deviation `sd`.
}
}
\description{
Allocates patients to one of treatments based on sequential
estimation-adjusted urn model (SEU) with simulated data.
}
\details{
'SEU_simulation_main_GAUSSIAN' can sample response and adaptively
randomize subjects group by group.
}
\examples{

## Default method
SEU_simulation_main_GAUSSIAN(
n = 50,
nstart = round(50 / 20),
mu = c(4.5,5),
sd = c(1.32,0.72),
urn_comp = c(0,0),
nstop=c(50,50),
replication = 5,
group_allo = 1,
add_rule_index = 1,
add_rule = NULL,
add_rule_full = TRUE,
sig_level = 0.05
)

}
