% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_integration.R
\name{db_copy_to}
\alias{db_copy_to}
\alias{db_copy_to.AthenaConnection}
\title{S3 implementation of \code{db_copy_to} for Athena}
\usage{
db_copy_to.AthenaConnection(
  con,
  table,
  values,
  overwrite = FALSE,
  append = FALSE,
  types = NULL,
  partition = NULL,
  s3_location = NULL,
  file_type = c("csv", "tsv", "parquet"),
  compress = FALSE,
  max_batch = Inf,
  ...
)
}
\arguments{
\item{con}{A \code{\link{dbConnect}} object, as returned by \code{dbConnect()}}

\item{table}{A character string specifying a table name. Names will be
automatically quoted so you can use any sequence of characters, not
just any valid bare table name.}

\item{values}{A data.frame to write to the database.}

\item{overwrite}{Allow overwriting the destination table. Cannot be \code{TRUE} if \code{append} is also \code{TRUE}.}

\item{append}{Allow appending to the destination table. Cannot be \code{TRUE} if \code{overwrite} is also \code{TRUE}. Existing Athena DDL file type will be retained
and used when uploading data to AWS Athena. If parameter \code{file.type} doesn't match AWS Athena DDL file type a warning message will be created 
notifying user and \code{RAthena} will use the file type for the Athena DDL.}

\item{types}{Additional field types used to override derived types.}

\item{partition}{Partition Athena table (needs to be a named list or vector) for example: \code{c(var1 = "2019-20-13")}}

\item{s3_location}{s3 bucket to store Athena table, must be set as a s3 uri for example ("s3://mybucket/data/")}

\item{file_type}{What file type to store data.frame on s3, RAthena currently supports ["tsv", "csv", "parquet"]. Default delimited file type is "tsv", in previous versions
of \code{RAthena (=< 1.6.0)} file type "csv" was used as default. The reason for the change is that columns containing \code{Array/JSON} format cannot be written to 
Athena due to the separating value ",". This would cause issues with AWS Athena.                  
\strong{Note:} "parquet" format is supported by the \code{arrow} package and it will need to be installed to utilise the "parquet" format.}

\item{compress}{\code{FALSE | TRUE} To determine if to compress file.type. If file type is ["csv", "tsv"] then "gzip" compression is used, for file type "parquet" 
"snappy" compression is used.}

\item{max_batch}{Split the data frame by max number of rows i.e. 100,000 so that multiple files can be uploaded into AWS S3. By default when compression
is set to \code{TRUE} and file.type is "csv" or "tsv" max.batch will split data.frame into 20 batches. This is to help the 
performance of AWS Athena when working with files compressed in "gzip" format. \code{max.batch} will not split the data.frame 
when loading file in parquet format. For more information please go to \href{https://github.com/DyfanJones/RAthena/issues/36}{link}}

\item{...}{other parameters currently not supported in RAthena}
}
\value{
db_copy_to returns table name
}
\description{
This is an Athena method for dbplyr function \code{db_copy_to} to create an Athena table from a \code{data.frame}.
}
\examples{
\dontrun{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `RAthena::dbConnect` documnentation

library(DBI)
library(dplyr)

# Demo connection to Athena using profile name 
con <- dbConnect(RAthena::athena())

# List existing tables in Athena
dbListTables(con)

# Write data.frame to Athena table
copy_to(con, mtcars,
        s3_location = "s3://mybucket/data/")
             
# Checking if uploaded table exists in Athena
dbExistsTable(con, "mtcars")

# Write Athena table from tbl_sql
athena_mtcars <- tbl(con, "mtcars")
mtcars_filter <- athena_mtcars \%>\% filter(gear >=4)

copy_to(con, mtcars_filter)

# Checking if uploaded table exists in Athena
dbExistsTable(con, "mtcars_filter") 

# Disconnect from Athena
dbDisconnect(con)
}
}
\seealso{
\code{\link{AthenaWriteTables}}
}
