% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixplot.R
\name{plot.mix}
\alias{plot.mix}
\title{Plot mixture distributions}
\usage{
\method{plot}{mix}(x, prob = 0.99, fun = dmix, log = FALSE,
  comp = TRUE, size = 1.25, ...)
}
\arguments{
\item{x}{mixture distribution}

\item{prob}{defining lower and upper percentile of x-axis. Defaults to the 99\% central probability mass.}

\item{fun}{function to plot which can be any of \code{dmix}, \code{qmix} or \code{pmix}.}

\item{log}{log argument passed to the function specified in \code{fun}.}

\item{comp}{for the density function this can be set to \code{TRUE}
which will display colour-coded each mixture component of the
density in addition to the density.}

\item{size}{controls the linesize in plots.}

\item{...}{extra arguments passed on to the \code{\link[ggplot2]{qplot}} call.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object is returned.
}
\description{
Plot mixture distributions
}
\details{
Plot function for mixture distribution objects. It shows
the density/quantile/cumulative distribution (corresponds to
\code{d/q/pmix} function) for some specific central probability
mass defined by \code{prob}. By default the x-axis is chosen to
show 99\% of the probability density mass.
}
\section{Customizing \pkg{ggplot2} plots}{


The returned plot is a \pkg{ggplot2} object. Please refer to the
"Customizing Plots" vignette which is part of \pkg{RBesT}
documentation for an introduction. For simple modifications (change
labels, add reference lines, ...) consider the commands found in
\code{\link[bayesplot]{bayesplot-helpers}}. For more advanced
customizations please use the \pkg{ggplot2} package directly. A
description of the most common tasks can be found in the
\href{http://www.cookbook-r.com/Graphs/}{R Cookbook} and a full
reference of available commands can be found at the
\href{http://ggplot2.tidyverse.org/reference/}{ggplot2 documentation
site}.
}

\examples{
# beta with two informative components
bm <- mixbeta(inf=c(0.5, 10, 100), inf2=c(0.5, 30, 80))
plot(bm)
plot(bm, fun=pmix)

# for customizations of the plot we need to load ggplot2 first
library(ggplot2)

# show a histogram along with the density
plot(bm) + geom_histogram(data=data.frame(x=rmix(bm, 1000)),
                          aes(y=..density..), bins=50, alpha=0.4)

\donttest{
# note: we can also use bayesplot for histogram plots with a density ...
library(bayesplot)
mh <- mcmc_hist(data.frame(x=rmix(bm, 1000)), freq=FALSE) +
         overlay_function(fun=dmix, args=list(mix=bm))
# ...and even add each component
for(k in 1:ncol(bm))
  mh <- mh + overlay_function(fun=dmix, args=list(mix=bm[[k]]), linetype=I(2))
print(mh)
}

# normal mixture
nm <- mixnorm(rob=c(0.2, 0, 2), inf=c(0.8, 6, 2), sigma=5)
plot(nm)
plot(nm, fun=qmix)

# obtain ggplot2 object and change title
pl <- plot(nm)
pl + ggtitle("Normal 2-Component Mixture")

}
\seealso{
Other mixdist: \code{\link{mixbeta}},
  \code{\link{mixcombine}}, \code{\link{mixgamma}},
  \code{\link{mixnorm}}, \code{\link{mix}}
}
\concept{mixdist}
