% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_gMAP.R
\name{predict.gMAP}
\alias{predict.gMAP}
\alias{print.gMAPpred}
\alias{summary.gMAPpred}
\alias{as.matrix.gMAPpred}
\title{Predictions from gMAP analyses}
\usage{
\method{predict}{gMAP}(
  object,
  newdata,
  type = c("response", "link"),
  probs = c(0.025, 0.5, 0.975),
  na.action = na.pass,
  thin,
  ...
)

\method{print}{gMAPpred}(x, digits = 3, ...)

\method{summary}{gMAPpred}(object, ...)

\method{as.matrix}{gMAPpred}(x, ...)
}
\arguments{
\item{newdata}{data.frame which must contain the same columns as
input into the gMAP analysis. If left out, then a posterior prediction for
the fitted data entries from the gMAP object is performed (shrinkage estimates).}

\item{type}{sets reported scale (\code{response} (default) or \code{link}).}

\item{probs}{defines quantiles to be reported.}

\item{na.action}{how to handle missings.}

\item{thin}{thinning applied is derived from the \code{gMAP} object.}

\item{...}{ignored.}

\item{x, object}{gMAP analysis object for which predictions are performed}

\item{digits}{number of displayed significant digits.}
}
\description{
Produces a sample of the predictive distribution.
}
\details{
Predictions are made using the \eqn{\tau} prediction
stratum of the gMAP object. For details on the syntax, please refer
to \code{\link{predict.glm}} and the example below.
}
\examples{
## Setting up dummy sampling for fast execution of example
## Please use 4 chains and 20x more warmup & iter in practice
.user_mc_options <- options(RBesT.MC.warmup=50, RBesT.MC.iter=100,
                            RBesT.MC.chains=2, RBesT.MC.thin=1)

# create a fake data set with a covariate
trans_cov <- transform(transplant, country = cut(1:11, c(0, 5, 8, Inf), c("CH", "US", "DE")))
set.seed(34246)
map <- gMAP(cbind(r, n - r) ~ 1 + country | study,
  data = trans_cov,
  tau.dist = "HalfNormal",
  tau.prior = 1,
  # Note on priors: we make the overall intercept weakly-informative
  # and the regression coefficients must have tighter sd as these are
  # deviations in the default contrast parametrization
  beta.prior = rbind(c(0, 2), c(0, 1), c(0, 1)),
  family = binomial,
  ## ensure fast example runtime
  thin = 1, chains = 1
)

# posterior predictive distribution for each input data item (shrinkage estimates)
pred_cov <- predict(map)
pred_cov

# extract sample as matrix
samp <- as.matrix(pred_cov)

# predictive distribution for each input data item (if the input studies were new ones)
pred_cov_pred <- predict(map, trans_cov)
pred_cov_pred


# a summary function returns the results as matrix
summary(pred_cov)

# obtain a prediction for new data with specific covariates
pred_new <- predict(map, data.frame(country = "CH", study = 12))
pred_new
## Recover user set sampling defaults
options(.user_mc_options)

}
\seealso{
\code{\link{gMAP}}, \code{\link{predict.glm}}
}
