% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{get_objects}
\alias{get_objects}
\title{Extract objects of prepositional phrases in row and column labels}
\usage{
get_objects(
  labels,
  notation = RCLabels::bracket_notation,
  prepositions = RCLabels::prepositions
)
}
\arguments{
\item{labels}{The row and column labels from which prepositional phrases are to be extracted.}

\item{notation}{The notation object that describes the labels.
Default is \code{RCLabels::bracket_notation}.}

\item{prepositions}{A vector of strings to be treated as prepositions.
Note that a space is appended to each word internally,
so, e.g., "to" becomes "to ".
Default is \code{RCLabels::prepositions}.}
}
\value{
A list of objects of prepositional phrases,
with names being prepositions, and values being objects.
}
\description{
This function extracts the objects of prepositional phrases
from row and column labels.
The format of the output is a list of
named items, one name for each preposition encountered in labels.
Objects are \code{NA} if there is no prepositional phrase starting
with that preposition.
}
\examples{
get_objects(c("a [of b into c]", "d [of Coal from e -> f]"))
}
