% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{make_or_pattern}
\alias{make_or_pattern}
\title{Create "or" regex patterns}
\usage{
make_or_pattern(
  strings,
  pattern_type = c("exact", "leading", "trailing", "anywhere", "literal")
)
}
\arguments{
\item{strings}{A vector of row and column names.}

\item{pattern_type}{One of "exact", "leading", "trailing", "anywhere", or "literal". Default is "exact".}
}
\value{
An "or" regex pattern suitable for selecting row and column names.
Amenable for use with \code{matsbyname::select_rows_byname} or \code{matsbyname::select_cols_byname}.
}
\description{
This function makes "or" regex patterns from vectors or lists of strings.
This function can be used with the \code{matsbyname::select_rows_byname()}
and \code{matsbyname::select_cols_byname} functions.
\code{make_or_pattern()} correctly escapes special characters in \code{strings},
such as \code{(} and \verb{)}, as needed.
Thus, it is highly recommended that \code{make_or_pattern} be used when
constructing patterns for row and column selections with
\code{matsbyname::select_rows_byname()} and \code{matsbyname::select_cols_byname()}.
}
\details{
\code{pattern_type} controls the type of pattern created:
\itemize{
\item{\code{exact} produces a regex pattern that selects row or column names by exact match.}
\item{\code{leading} produces a regex pattern that selects row or column names if the item in \code{strings} matches
the beginnings of row or column names.}
\item{\code{trailing} produces a regex pattern that selects row or column names if the item in \code{strings} matches
the ends of row or column names.}
\item{\code{anywhere} produces a regex pattern that selects row or column names if the item in \code{strings} matches
any substring of row or column names.}
\item{\code{literal} returns \code{strings} unmodified, and it is up to the caller to formulate a correct regex.}
}
}
\examples{
make_or_pattern(strings = c("a", "b"), pattern_type = "exact")
make_or_pattern(strings = c("a", "b"), pattern_type = "leading")
make_or_pattern(strings = c("a", "b"), pattern_type = "trailing")
make_or_pattern(strings = c("a", "b"), pattern_type = "anywhere")
make_or_pattern(strings = c("a", "b"), pattern_type = "literal")
}
