% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{regex_funcs}
\alias{regex_funcs}
\alias{match_by_pattern}
\alias{replace_by_pattern}
\title{Find or replace row or column labels that match a regular expression}
\usage{
match_by_pattern(
  labels,
  regex_pattern,
  pieces = "all",
  prepositions = RCLabels::prepositions_list,
  notation = RCLabels::bracket_notation,
  ...
)

replace_by_pattern(
  labels,
  regex_pattern,
  replacement,
  pieces = "all",
  prepositions = RCLabels::prepositions_list,
  notation = RCLabels::bracket_notation,
  ...
)
}
\arguments{
\item{labels}{The row and column labels to be modified.}

\item{regex_pattern}{The regular expression pattern to determine matches and replacements.
Consider using \code{Hmisc::escapeRegex()} to escape \code{regex_pattern}
before calling this function.}

\item{pieces}{The pieces of row or column labels to be checked for matches or replacements.
See details.}

\item{prepositions}{A vector of strings that count as prepositions.
Default is \code{RCLabels::prepositions_list}.
Used to detect prepositional phrases
if \code{pieces} are to be interpreted as prepositions.}

\item{notation}{The notation used in \code{labels}.
Default is \code{RCLabels::bracket_notation}.}

\item{...}{Other arguments passed to \code{grepl()} or \code{gsub()},
such as \code{ignore.case}, \code{perl}, \code{fixed},
or \code{useBytes}.
See examples.}

\item{replacement}{For \code{replace_by_pattern()}, the string that replaces
all matches to \code{regex_pattern}.}
}
\value{
A logical vector of same length as \code{labels},
where \code{TRUE} indicates a match was found and \code{FALSE} indicates otherwise.
}
\description{
\code{match_by_pattern()} tells whether row or column labels
match a regular expression.
Internally, \code{grepl()} decides whether a match occurs.
\code{replace_by_pattern()} replaces portions of row of column labels
when a regular expression is matched.
Internally, \code{gsub()} performs the replacements.
}
\details{
By default (\code{pieces = "all"}), complete labels (as strings) are checked for matches
and replacements.
If \code{pieces == "pref"} or \code{pieces == "suff"},
only the prefix or the suffix is checked for matches and replacements.
Alternatively, \code{pieces = "noun"} or \verb{pieces = <<preposition>>} indicate
that only specific pieces of labels are to be checked for matches and replacements.
When \verb{pieces = <<preposition>>}, only the object of \verb{<<preposition>>} is
checked for matches and replacement.

\code{pieces} can be a vector, indicating multiple pieces to be checked for matches
and replacements.
But if any of the \code{pieces} are "all", all pieces are checked and replaced.
If \code{pieces} is "pref" or "suff", only one can be specified.
}
\examples{
labels <- c("Production [of b in c]", "d [of Coal in f]", "g [of h in USA]")
# With default `pieces` argument, matching is done for whole labels.
match_by_pattern(labels, regex_pattern = "Production")
match_by_pattern(labels, regex_pattern = "Coal")
match_by_pattern(labels, regex_pattern = "USA")
# Check beginnings of labels
match_by_pattern(labels, regex_pattern = "^Production")
# Check at ends of labels: no match.
match_by_pattern(labels, regex_pattern = "Production$")
# Can match on nouns or prepositions.
match_by_pattern(labels, regex_pattern = "Production", pieces = "noun")
# Gives FALSE, because "Production" is a noun.
match_by_pattern(labels, regex_pattern = "Production", pieces = "in")
}
