% Generated by roxygen2 (4.0.1): do not edit by hand
\name{makeAnnualStat}
\alias{makeAnnualStat}
\title{Compute annual statistic of a variable}
\usage{
makeAnnualStat(x, verbose = FALSE, parallel = FALSE, FUN = mean, ...)
}
\arguments{
\item{x}{A \code{\link{cmip5data}} object}

\item{verbose}{logical. Print info as we go?}

\item{parallel}{logical. Parallelize if possible?}

\item{FUN}{function. Function to apply across months of year}

\item{...}{Other arguments passed on to \code{FUN}}
}
\value{
A \code{\link{cmip5data}} object, whose \code{val} field is the annual
mean of the variable. A \code{numMonths} field is also added
recording the number of months averaged for each year.
}
\description{
Most CMIP5 data are monthly, and we frequently want to summarize these to annual
numbers. This function does that (although annual files also occur, and will be
handled as well). The default statistic is \link{mean}, but any summary
function that returns a numeric result can be used.
}
\details{
If Z dimension is present, the stat function is calculated
for all values of these. No status bar is printed when processing in parallel,
but progress is logged to a file (call with verbose=T) that can be monitored.

If the user requests parallel processing (via parallel=T) makeAnnualStat
(i) attempts to load the \code{doParallel} package, and (ii) registers it as a
parallel backend \emph{unless} the user has already done this (e.g. set up a
virtual cluster with particular, desired characteristics). In that case,
makeAnnualStat respects the existing cluster.
}
\note{
The \code{val} component of the returned object will always be the same structure
as \code{x}, i.e. of dimensions {x, y, z, t}.
}
\examples{
d <- cmip5data(1970:1975)   # sample data
makeAnnualStat(d)
summary(makeAnnualStat(d))
\dontrun{
library(doParallel)
registerDoParallel()
summary(makeMonthlyStat(d, verbose=TRUE, parallel=TRUE))
}
summary(makeAnnualStat(d, FUN=sd))
}
\seealso{
\code{\link{makeZStat}} \code{\link{makeGlobalStat}} \code{\link{makeMonthlyStat}}
}

