% Generated by roxygen2 (4.0.1): do not edit by hand
\name{saveNetCDF}
\alias{saveNetCDF}
\title{Save a cmip5data object to netCDF format}
\usage{
saveNetCDF(x, file = NULL, path = "./", verbose = FALSE,
  saveProvenance = TRUE, originalNames = FALSE, force.ncdf = FALSE)
}
\arguments{
\item{x}{A \code{\link{cmip5data}} object}

\item{file}{Filename desired. If omitted one will be generated automatically.}

\item{path}{File path.}

\item{verbose}{logical. Print info as we go?}

\item{saveProvenance}{Save the provenance separately?}

\item{originalNames}{logical. Use original dimension names from file?}

\item{force.ncdf}{Force use of the older ncdf package for testing?}
}
\value{
The fully-qualified filename that was written (invisible).
}
\description{
There are at least three ways to save a \code{\link{cmip5data}} object.
First, \link{save} it. Second, use \link{as.data.frame}. Third, this function
will write out a new netCDF file readable by any netCDF-aware software.
}
\details{
If no filename is provided, a meaningful one will be assigned based on the
CMIP5 naming convention (but appending 'RCMIP5'). \code{\link{loadCMIP5}} should be
able to read this file. If \code{saveProvenance} is specified, the provenance is saved
separately in a comma-separated file of the same name but appending "_prov.csv".
(Provenance messages are always saved as netcdf file attributes.)
}

