% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCMIP5.R
\name{cmip5.weighted.mean}
\alias{cmip5.weighted.mean}
\title{Alternative weighted mean}
\usage{
cmip5.weighted.mean(x, w = rep(1, length(x)), na.rm = TRUE)
}
\arguments{
\item{x}{vector of data}

\item{w}{vector of weights}

\item{na.rm}{Remove NAs in both data and weights?}
}
\value{
Weighted mean of \code{x}, using weights \code{d}.
}
\description{
Alternative weighted mean
}
\details{
The \code{stats} version of weighted.mean doesn't handle weights in a very 
useful way. Specifically, it will remove missing \code{x} values, but not missing weights.
A fair number of CMIP5 models have \code{NA} values in their grid areas, so this will
quickly cause problems. This function removes (if \code{na.rm=TRUE}) missing observations
and weights before computing the weighted mean.
}
\seealso{
\code{\link{weighted.mean}}
}

