% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regrid.R
\name{getProjectionMatrix}
\alias{getProjectionMatrix}
\title{Calculate projection matrix to translate one grid to another}
\usage{
getProjectionMatrix(orgArea, projArea, verbose = FALSE)
}
\arguments{
\item{orgArea}{A \code{\link{cmip5data}} object or list with \code{lat} (latitude) 
and \code{lon} (longitude) matrices of the orginal grid}

\item{projArea}{A \code{\link{cmip5data}} object or list with \code{lat} (latitude) 
and \code{lon} (longitude) matrices of the projection grid}

\item{verbose}{logical. Print info as we go?}
}
\description{
The bulk of the computational time for regridding lies in calculating the 
area-weighted projection matrix. This functions allows you to pre-calculate the 
projection matrix to speed up regridding.
}
\details{
This function calculates the projection matrix to shift one global grid to a second.
The relative contribution of an old grid to the new grid is calculated via an area weighting scheme
where the area of a grid cell is assumed to be proportional to the degree area of that cell and
neighboring cells are assumed to have the same area to degree ratios. This will NOT hold in large grids.
Nor is the area weighting scheme appropriate for all variable types and grid shifts. Use with caution.
}
\examples{
numOrgLon <- 3
numOrgLat <- 3
orgLon <- matrix(seq(0, 360-360/numOrgLon, by=360/numOrgLon) + 360/numOrgLon/2, 
                 nrow=numOrgLon, ncol=numOrgLat)
orgLat <- matrix(seq(-90, 90-180/numOrgLat, by=180/numOrgLat) + 180/numOrgLat/2, 
                 nrow=numOrgLon, ncol=numOrgLat, byrow=TRUE)
orgArea <- list(lon = orgLon, lat=orgLat)

numProjLon <- 2
numProjLat <- 2
projLon <- matrix(seq(0, 360-360/numProjLon, by=360/numProjLon) + 360/numProjLon/2, 
                 nrow=numProjLon, ncol=numProjLat)
projLat <- matrix(seq(-90, 90-180/numProjLon, by=180/numProjLon) + 180/numProjLon/2, 
                 nrow=numProjLon, ncol=numProjLat, byrow=TRUE)
projArea <- list(lon = projLon, lat=projLat)

transferMatrix <- getProjectionMatrix(orgArea = orgArea, projArea=projArea)
}
\seealso{
\code{\link{regrid}}
}

