% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{initialise_beta}
\alias{initialise_beta}
\title{Initialisation of estimation of beta (the coefficients with the observable variables)}
\usage{
initialise_beta(
  Y,
  X,
  S,
  robust,
  method_estimate_beta = "individual",
  nosetting_lmrob = FALSE,
  special_case_dgp1 = FALSE
)
}
\arguments{
\item{Y}{Y: NxT dataframe with the panel data of interest}

\item{X}{dataframe with the observed variables}

\item{S}{estimated number of groups}

\item{robust}{robust or classical estimation}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{nosetting_lmrob}{option to remove the recommended setting in lmrob(). It is much faster. Defaults to FALSE.}

\item{special_case_dgp1}{special case for data generated according to dgp 1: it changes the 1st variable in X to 1 (-> intercept). Consequently the estimation of beta needs to be restructured slightly.}
}
\value{
Matrix with number of rows equal to the number of estimated variables plus one. If method_estimate_beta is set to the default ("individual"),
the number of columns is equal to the number of time series in Y. If method_estimate_beta is set to "group" or to "homogeneous" the number of columns
is equal to the number of groups.
}
\description{
Note: this needs to be called before the definition of grid.
}
\examples{
\donttest{
X <- X_dgp3
Y <- Y_dgp3
# Set estimations for group factors and its loadings, and group membership
#  to the true value for this example.
lambda_group <- lambda_group_true_dgp3
factor_group <- factor_group_true_dgp3
beta_init <- initialise_beta(Y, X,
  S = 3, TRUE
)
}
}
