% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/okresy.R
\name{okresy}
\alias{okresy}
\title{Districts (okresy)}
\format{\code{sf} data frame with 77 rows of 6 variables + geometry

\describe{
  \item{KOD_OKRES}{Code of the district (okres).}
  \item{KOD_LAU1}{Code of the district as LAU1 unit (okres), primary key. Use this as key to add other data items.}
  \item{NAZ_LAU1}{Name of the district as LAU1 unit (okres).}
  \item{KOD_KRAJ}{Code of the region.}
  \item{KOD_CZNUTS3}{Code of the region as NUTS3 (kraj).}
  \item{NAZ_CZNUTS3}{Name of the region (kraj).}
}}
\source{
\url{https://www.arcdata.cz/produkty/geograficka-data/arccr-500}
}
\usage{
okresy(resolution = "high", method = "curl")
}
\arguments{
\item{resolution}{Should the function return high or low resolution shapefile? Allowed values are "high" (default) and "low". This parameter affects only the geometry column, all other fields remain the same.}

\item{method}{Method argument for `download.file()`. The default (i.e. "curl") should be appropriate in most situations.}
}
\description{
Function returning data frame of LAU1 administrative units for the Czech Republic as \code{sf} polygons. It takes a single parameter resolution - high res (default) or low res polygons.
}
\details{
Due to package size constraints the data are stored externally (and a working internet connection is required to use the package). Downloaded size of high resolution shapefile is 6.1 MB (so use with caution, and patience).
}
\examples{
\donttest{
library(sf)

hranice <- okresy()
plot(hranice, col = "white", max.plot = 1)

object.size(okresy("low"))
object.size(okresy("high"))
}
}
