% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kraje.R
\name{kraje}
\alias{kraje}
\title{Regions (kraje) of the Czech Republic}
\format{
\code{sf} data frame with 14 rows of 3 variables + geometry

\describe{
  \item{KOD_KRAJ}{Code of the region.}
  \item{KOD_CZNUTS3}{Code of the region as NUTS3 (kraj).}
  \item{NAZ_CZNUTS3}{Name of the region as NUTS3 (kraj).}
}
}
\source{
© ČÚZK, 2021 \url{https://vdp.cuzk.cz/}
}
\usage{
kraje(resolution = "high")
}
\arguments{
\item{resolution}{Should the function return high or low resolution shapefile? Allowed values are "high" (default) and "low". This parameter affects only the geometry column, all other fields remain the same.}
}
\description{
Function returning data frame of NUTS3 administrative units for the Czech Republic as \code{sf} polygons. It takes a single parameter resolution - high res (default) or low res polygons.
}
\details{
Due to package size constraints the data are stored externally (and a working internet connection is required to use the package).

The data is current to February 2021 (i.e changes introduced by act 51/2020 Sb. are reflected). Downloaded size of high resolution shapefile is <1 MB.
}
\examples{
\donttest{
library(sf)

hranice <- kraje("low")
plot(hranice, col = "white", max.plot = 1)
}
}
