# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Ramer-Douglas-Peucker
#'
#' The [Ramer-Douglas-Peucker algorithm](https://en.wikipedia.org/wiki/Ramer-Douglas-Peucker_algorithm) for reducing the number of points on a curve.
#'
#' @details If there are no more than two points it does not make sense to simplify.
#' In this case the input is returned without further checks of `x` and `y`.
#'
#' @param x The `x` values of the curve as a vector.
#' @param y The `y` values of the curve as a vector.
#' @param epsilon The threshold for filtering outliers from the simplified curve.
#'
#' @return A `data.frame` with `x` and `y` values of the simplified curve.
#'
#' @examples
#' RDP::RamerDouglasPeucker(x = c(0, 1, 3, 5), y = c(2, 1, 0, 1), epsilon = 0.5)
#'
#' @export
#'
RamerDouglasPeucker <- function(x, y, epsilon) {
    .Call(`_RDP_RamerDouglasPeucker`, x, y, epsilon)
}

