% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence.R
\name{bootstrap.incidence}
\alias{bootstrap.incidence}
\title{Calculates incidence and bootstrap confidence intervals for immunoassay data collected with RDS}
\usage{
bootstrap.incidence(rds.data, recent.variable, hiv.variable, N = NULL,
  weight.type = c("Gile's SS", "RDS-I", "RDS-I (DS)", "RDS-II",
  "Arithmetic Mean", "HCG"), mean.duration = 200, frr = 0.01,
  post.infection.cutoff = 730, number.of.bootstrap.samples = 1000,
  se.mean.duration = 0, se.frr = 0, confidence.level = 0.95,
  verbose = TRUE, ...)
}
\arguments{
\item{rds.data}{an rds.data.frame}

\item{recent.variable}{The name of the variable indicating recent infection}

\item{hiv.variable}{The name of the variable indicating of hiv infection}

\item{N}{Population size}

\item{weight.type}{A string giving the type of estimator to use. The options
are \code{"Gile's SS"}, \code{"RDS-I"}, \code{"RDS-II"}, \code{"RDS-I/DS"},
and \code{"Arithemic Mean"}. It defaults to \code{"Gile's
SS"}.}

\item{mean.duration}{Estimated mean duration of recent infection (MDRI) (days)}

\item{frr}{Estimated false-recent rate (FRR)}

\item{post.infection.cutoff}{Post-infection time cut-off T, separating "true-recent" from "false-recent" results (days)}

\item{number.of.bootstrap.samples}{The number of bootstrap samples used to construct the interval.}

\item{se.mean.duration}{The standard error of the mean.duration estimate}

\item{se.frr}{The standard error of the false recency estimate}

\item{confidence.level}{The level of confidence for the interval}

\item{verbose}{verbosity control}

\item{...}{additional arguments to compute.weights}
}
\description{
Calculates incidence and bootstrap confidence intervals for immunoassay data collected with RDS
}
\details{
The recent.variable and hiv should be the names of logical variables. Otherwise they are converted to logical using as.numeric(x) > 0.5.

This function estimates incidence using RDS sampling wieghts. Confidence intervals are constucted using HCG bootstraps.
See http://www.incidence-estimation.org/ for additional information on (non-RDS) incidence estimation.
}
\examples{
data(faux)
faux$hiv <- faux$X == "blue"
faux$recent <- NA
faux$recent[faux$hiv] <- runif(sum(faux$hiv)) < .2
faux$recent[runif(nrow(faux)) > .5] <- NA
faux$hiv[is.na(faux$recent)][c(1,6,10,21)] <- NA
attr(faux,"time") <- "wave"
bootstrap.incidence(faux,"recent","hiv",weight.type="RDS-II", number.of.bootstrap.samples=100)
}

