% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gammamix.R
\name{Gammamix}
\alias{Gammamix}
\title{NPMLE for Gamma Mixtures}
\usage{
Gammamix(x, v = 300, shape = 1, weights = NULL, ...)
}
\arguments{
\item{x}{vector of observed variances}

\item{v}{A vector of bin boundaries, if scalar then v equally spaced bins
are constructed}

\item{shape}{vector of shape parameters corresponding to x}

\item{weights}{replicate weights for x obervations, should sum to 1}

\item{...}{optional parameters passed to KWDual to control optimization}
}
\value{
An object of class \code{density} with components:
	\item{x}{midpoints of the bin boundaries} 
	\item{y}{estimated function values of the mixing density} 
	\item{g}{function values of the mixture density at the observed x's.} 
	\item{logLik}{the value of the log likelihood at the solution} 
	\item{dy}{Bayes rule estimates of } 
	\item{status}{the Mosek convergence status.}
}
\description{
A Kiefer-Wolfowitz MLE for Gamma mixture models
}
\references{
Gu J. and R. Koenker (2014) Unobserved heterogeneity in 
income dynamics: an empirical Bayes perspective, \emph{JBES}, 35, 1-16.

Koenker, R. and J. Gu, (2017) REBayes: An {R} Package for Empirical Bayes Mixture Methods,
\emph{Journal of Statistical Software}, 82, 1--26.
}
\seealso{
Gammamix for a general implementation for Gamma mixtures
}
\author{
J. Gu and R. Koenker
}
\keyword{nonparametric}
