% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_redcap_instrument.R
\name{export_redcap_instrument}
\alias{export_redcap_instrument}
\title{Creates zip-file with necessary content to manually add instrument to database}
\usage{
export_redcap_instrument(data, file, force = FALSE, record.id = "record_id")
}
\arguments{
\item{data}{metadata for the relevant instrument.
Could be from `ds2dd_detailed()`}

\item{file}{destination file name.}

\item{force}{force instrument creation and ignore different form names by
just using the first.}

\item{record.id}{record id variable name. Default is 'record_id'.}
}
\value{
exports zip-file
}
\description{
Metadata can be added by editing the data dictionary of a project in the
initial design phase. If you want to later add new instruments, this
function can be used to create (an) instrument(s) to add to a project in
production.
}
\examples{
#iris |>
#  ds2dd_detailed(
#    add.auto.id = TRUE,
#    form.name = sample(c("b", "c"), size = 6, replace = TRUE, prob = rep(.5, 2))
#  ) |>
#  purrr::pluck("meta") |>
#  (\(.x){
#  split(.x, .x$form_name)
#  })() |>
#  purrr::imap(function(.x, .i){
#  export_redcap_instrument(.x,file=here::here(paste0(.i,Sys.Date(),".zip")))
#  })

#iris |>
#  ds2dd_detailed(
#    add.auto.id = TRUE
#  ) |>
#  purrr::pluck("meta") |>
#  export_redcap_instrument(file=here::here(paste0("instrument",Sys.Date(),".zip")))
}
