% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/validate_for_write.R
\name{validate_for_write}
\alias{validate_for_write}
\alias{validate_no_logical}
\alias{validate_no_uppercase}
\title{Inspect a \code{data.frame} to anticipate problems before writing to a REDCap project.}
\usage{
validate_for_write( d )

validate_no_logical( d )

validate_no_uppercase( d )
}
\arguments{
  \item{d}{The \code{data.frame} containing the dataset
  used to update the REDCap project.  Required.}
}
\value{
A \code{data.frame}, where each potential violation is a
row.  The two columns are: \enumerate{ \item
\code{field_name}: The name of the \code{data.frame} that
might cause problems during the upload.  \item
\code{field_index}: The position of the field.  (For
example, a value of '1' indicates the first column, while a
'3' indicates the third column.)  \item \code{concern}: A
description of the problem potentially caused by the
\code{field}.  \item \code{suggestion}: A \emph{potential}
solution to the concern. }
}
\description{
This set of functions inspect a \code{data.frame} to
anticipate problems before writing with REDCap's
\href{https://iwg.devguard.com/trac/redcap/wiki/ApiExamples}{API}.
}
\details{
All functions listed in the Usage section above inspect a
specific aspect of the dataset.  The
\code{validate_for_read()} function executes all these
individual validation checks.  It allows the client to
check everything with one call.
}
\examples{
d <- data.frame(
  record_id = 1:4,
  flag_logical = c(TRUE, TRUE, FALSE, TRUE),
  flag_Uppercase = c(4, 6, 8, 2)
)
validate_for_write(d = d)
}
\author{
Will Beasley
}

