% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap-file-download-oneshot.R
\name{redcap_file_download_oneshot}
\alias{redcap_file_download_oneshot}
\alias{redcap_download_file_oneshot}
\title{Download a file from a REDCap project record}
\usage{
redcap_file_download_oneshot(
  file_name = NULL,
  directory = NULL,
  overwrite = FALSE,
  redcap_uri,
  token,
  record,
  field,
  event = "",
  repeat_instance = NULL,
  verbose = TRUE,
  config_options = NULL,
  handle_httr = NULL
)
}
\arguments{
\item{file_name}{The name of the file where the downloaded file is saved.
If empty the original name of the file will be used and saved in the
default directory.  Optional.}

\item{directory}{The directory where the file is saved. By default current
directory. Optional}

\item{overwrite}{Boolean value indicating if existing files should be
overwritten. Optional}

\item{redcap_uri}{The
\href{https://en.wikipedia.org/wiki/Uniform_Resource_Identifier}{uri}/url
of the REDCap server
typically formatted as "https://server.org/apps/redcap/api/".
Required.}

\item{token}{The user-specific string that serves as the password for a
project.  Required.}

\item{record}{The record ID where the file is to be imported. Required}

\item{field}{The name of the field where the file is saved in REDCap.
Required}

\item{event}{The name of the event where the file is saved in REDCap.
Optional}

\item{repeat_instance}{(only for projects with repeating instruments/events)
The repeat instance number of the repeating event (if longitudinal) or the
repeating instrument (if classic or longitudinal). Default value is '1'.
Optional}

\item{verbose}{A boolean value indicating if \code{message}s should be printed
to the R console during the operation.  Optional.}

\item{config_options}{A list of options passed to \code{\link[httr:POST]{httr::POST()}}.
See details at \code{\link[httr:httr_options]{httr::httr_options()}}. Optional.}

\item{handle_httr}{The value passed to the \code{handle} parameter of
\code{\link[httr:POST]{httr::POST()}}.
This is useful for only unconventional authentication approaches.  It
should be \code{NULL} for most institutions.  Optional.}
}
\value{
Currently, a list is returned with the following elements,
\itemize{
\item \code{success}: A boolean value indicating if the operation was apparently
successful.
\item \code{status_code}: The
\href{https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}{http status code}
of the operation.
\item \code{outcome_message}: A human readable string indicating the operation's
outcome.
\item \code{records_affected_count}: The number of records inserted or updated.
\item \code{affected_ids}: The subject IDs of the inserted or updated records.
\item \code{elapsed_seconds}: The duration of the function.
\item \code{raw_text}: If an operation is NOT successful, the text returned by
REDCap.  If an operation is successful, the \code{raw_text} is returned as an
empty string to save RAM.
\item \code{file_name}: The name of the file persisted to disk. This is useful if
the name stored in REDCap is used (which is the default).
}
}
\description{
This function uses REDCap's API to download a file.
}
\details{
For files in a repeating instrument, don't specify \code{repeating_instrument}.
The server only needs \code{field} (name) and \code{repeating_instance}.

The function \code{redcap_download_file_oneshot()} is soft-deprecated
as of REDCapR 1.2.0.
Please rename to \code{\link[=redcap_file_download_oneshot]{redcap_file_download_oneshot()}}.
}
\examples{
\dontrun{
uri     <- "https://bbmc.ouhsc.edu/redcap/api/"
token   <- "D70F9ACD1EDD6F151C6EA78683944E98" # pid=213
record  <- 1
field   <- "mugshot"
# event <- "" # only for longitudinal projects

result_1 <- REDCapR::redcap_file_download_oneshot(
  record        = record,
  field         = field,
  redcap_uri    = uri,
  token         = token
)
base::unlink("mugshot-1.jpg")

(full_name <- base::tempfile(pattern="mugshot", fileext = ".jpg"))
result_2   <- REDCapR::redcap_file_download_oneshot(
  file_name     = full_name,
  record        = record,
  field         = field,
  redcap_uri    = uri,
  token         = token
)
base::unlink(full_name)

(relative_name <- "ssss.jpg")
result_3 <- REDCapR::redcap_file_download_oneshot(
  file_name    = relative_name,
  record       = record,
  field        = field,
  redcap_uri   = uri,
  token        = token
)
base::unlink(relative_name)
}
}
\references{
The official documentation can be found on the 'API Help Page'
and 'API Examples' pages on the REDCap wiki (\emph{i.e.},
https://community.projectredcap.org/articles/456/api-documentation.html and
https://community.projectredcap.org/articles/462/api-examples.html).
If you do not have an account for the wiki, please ask your campus REDCap
administrator to send you the static material.
}
\author{
Will Beasley, John J. Aponte
}
