% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_redcap.R
\name{update_dag_cols}
\alias{update_dag_cols}
\title{Implement REDCapR DAG Data into Supertibble}
\usage{
update_dag_cols(data, dag_data, raw_or_label)
}
\arguments{
\item{data}{the REDCap data}

\item{dag_data}{a DAG dataset exported from \link[REDCapR:redcap_dag_read]{REDCapR::redcap_dag_read}}

\item{raw_or_label}{A string (either 'raw', 'label', or 'haven') that specifies whether
to export the raw coded values or the labels for the options of categorical
fields. Default is 'label'. If 'haven' is supplied, categorical fields are converted
to \code{haven_labelled} vectors.}
}
\description{
This helper function uses output from \link[REDCapR:redcap_dag_read]{REDCapR::redcap_dag_read} and applies the necessary
raw/label values to the \code{redcap_data_access_group} column.

This is done because REDCapTidieR retrieves raw data by default, then merges
labels from the metadata. However, some columns like
\code{redcap_data_access_group} are not in the metadata and so there is nothing by
default to reference.
}
\keyword{internal}
