% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{REIDSFunction_ClusterVersion}
\alias{REIDSFunction_ClusterVersion}
\title{"REIDS_ClusterVersion"}
\usage{
REIDSFunction_ClusterVersion(geneData, nsim = 1000, geneID,
  informativeCalls = TRUE, rho = 0.5, Low_AllSamples)
}
\arguments{
\item{geneData}{The data with as rows the probesets and as columns the samples. Note that the first column should contain the gene IDs and the second column the exon IDs}

\item{nsim}{The number of iterations to perform.}

\item{geneID}{A vector of the gene IDs.}

\item{informativeCalls}{Logical. Should the I/NI calls method be perform before applying the REIDS model?}

\item{rho}{The threshold for filtering in the I/NI calls method. Probesets with scores higher than rho are kept.}

\item{Low_AllSamples}{A character vector containing the probe sets which are not DABG in all samples.}
}
\value{
A .RData file will be saved for each gene with the elements returned by the iniREIDS and REIDS functions.
}
\description{
The REIDS_ClusterVersion performs the REIDS model and was adapted for use on a HPC cluster. This function should be used with the REIDS_ClusterVersion.R file and REIDS_ClusterVersion.pbs script in the documentation folder of the package.
After running this function on the cluster, the output files should be binded together with the CreateOutput function.
}
