/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique.genome;

import javalain.algorithmegenetique.DomaineReel;
import javalain.algorithmegenetique.Genome;
import javalain.algorithmegenetique.gene.ReelDouble;
import javalain.algorithmegenetique.genome.ChromosomeFct;
import javalain.ea.SolutionEA;
import javalain.math.fonction.Fct;

public final class GenomeFct
extends Genome
implements SolutionEA {
    private static Fct fct;
    private double crowdingDistance = 0.0;
    private int rank = 0;
    public static int cpt_evaluation;

    public GenomeFct(Fct pFct) {
        super(1, pFct.getNbFctObjectif());
        fct = pFct;
        int nbVar = pFct.getNbVariable();
        ChromosomeFct cf = new ChromosomeFct(nbVar, 256, ChromosomeFct.mode_mutation.MUT_POLYNOMIALE, this);
        for (int i = 0; i < nbVar; ++i) {
            cf.addGene(new ReelDouble(new DomaineReel(fct.getLowerLimit(i), fct.getUpperLimit(i))));
        }
        this.addChromosome(cf);
    }

    public Fct getFct() {
        return fct;
    }

    public double[] getVariable() {
        return ((ChromosomeFct)this.getChromosome(0)).toArray();
    }

    public double[] getObjectif() {
        return this.notes;
    }

    public double getCrowdingDistance() {
        return this.crowdingDistance;
    }

    public void setCrowdingDistance(double pCrowdingDistance) {
        this.crowdingDistance = pCrowdingDistance;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int pRank) {
        this.rank = pRank;
    }

    public void fitness() {
        ++cpt_evaluation;
        this.notes = fct.compute(((ChromosomeFct)this.getChromosome(0)).toArray());
    }

    public StringBuilder afficher() {
        int i;
        StringBuilder sb = new StringBuilder();
        double[] d = this.getVariable();
        sb.append("x(");
        for (i = 0; i < d.length - 1; ++i) {
            sb.append(Genome.DF.format(d[i])).append(" ");
        }
        sb.append(Genome.DF.format(d[d.length - 1])).append(") ");
        d = this.getObjectif();
        sb.append("f(");
        for (i = 0; i < d.length - 1; ++i) {
            sb.append(Genome.DF.format(d[i])).append(" ");
        }
        sb.append(Genome.DF.format(d[d.length - 1])).append(")");
        sb.append(" Rank : ").append(this.rank);
        sb.append(" Crowding distance : ").append(Genome.DF.format(this.crowdingDistance));
        return sb;
    }

    static {
        cpt_evaluation = 0;
    }
}

