/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdistmulti;

import umontreal.iro.lecuyer.probdist.StudentDist;
import umontreal.iro.lecuyer.probdistmulti.ContinuousDistribution2Dim;

public class BiStudentDist
extends ContinuousDistribution2Dim {
    protected int nu;
    protected double rho;
    protected double facRho;

    public BiStudentDist(int n, double d) {
        this.setParams(n, d);
    }

    public double density(double d, double d2) {
        if (Math.abs(this.rho) == 1.0) {
            throw new IllegalArgumentException("|rho| = 1");
        }
        double d3 = 1.0 + (d * d - 2.0 * this.rho * d * d2 + d2 * d2) / ((double)this.nu * this.facRho * this.facRho);
        return 1.0 / (Math.pow(d3, (double)(this.nu + 2) / 2.0) * (Math.PI * 2 * this.facRho));
    }

    public double cdf(double d, double d2) {
        return BiStudentDist.cdf(this.nu, d, d2, this.rho);
    }

    public double barF(double d, double d2) {
        return BiStudentDist.barF(this.nu, d, d2, this.rho);
    }

    public static double density(int n, double d, double d2, double d3) {
        if (n < 1) {
            throw new IllegalArgumentException("nu < 1");
        }
        if (Math.abs(d3) >= 1.0) {
            throw new IllegalArgumentException("|rho| >= 1");
        }
        double d4 = (1.0 - d3) * (1.0 + d3);
        double d5 = 1.0 + (d * d - 2.0 * d3 * d * d2 + d2 * d2) / ((double)n * d4);
        return 1.0 / (Math.pow(d5, (double)(n + 2) / 2.0) * (Math.PI * 2 * Math.sqrt(d4)));
    }

    public static double cdf(int n, double d, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        if (n < 1) {
            throw new IllegalArgumentException("nu < 1");
        }
        if (Math.abs(d3) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        double d7 = d;
        double d8 = d2;
        if (1.0 - d3 <= 1.0E-15) {
            d = Math.min(d7, d8);
            return StudentDist.cdf(n, d);
        }
        if (d3 + 1.0 <= 1.0E-15) {
            if (d7 > -d8) {
                return StudentDist.cdf(n, d7) - StudentDist.cdf(n, -d8);
            }
            return 0.0;
        }
        double d9 = (1.0 - d3) * (1.0 + d3);
        double d10 = d7 - d3 * d8;
        double d11 = d8 - d3 * d7;
        if (Math.abs(d10) + d9 > 0.0) {
            d6 = d10 * d10 / (d10 * d10 + d9 * ((double)n + d8 * d8));
            d5 = d11 * d11 / (d11 * d11 + d9 * ((double)n + d7 * d7));
        } else {
            d6 = 0.0;
            d5 = 0.0;
        }
        int n2 = d7 - d3 * d8 > 0.0 ? 1 : (d7 - d3 * d8 < 0.0 ? -1 : 0);
        int n3 = d8 - d3 * d7 > 0.0 ? 1 : (d8 - d3 * d7 < 0.0 ? -1 : 0);
        if (n % 2 == 0) {
            d4 = Math.atan2(Math.sqrt(d9), -d3) / (Math.PI * 2);
            double d12 = d7 / Math.sqrt(16.0 * ((double)n + d7 * d7));
            double d13 = d8 / Math.sqrt(16.0 * ((double)n + d8 * d8));
            double d14 = 2.0 * Math.atan2(Math.sqrt(d5), Math.sqrt(1.0 - d5)) / Math.PI;
            double d15 = 2.0 * Math.sqrt(d5 * (1.0 - d5)) / Math.PI;
            double d16 = 2.0 * Math.atan2(Math.sqrt(d6), Math.sqrt(1.0 - d6)) / Math.PI;
            double d17 = 2.0 * Math.sqrt(d6 * (1.0 - d6)) / Math.PI;
            for (int i = 1; i <= n / 2; ++i) {
                d4 += d12 * (1.0 + (double)n3 * d14);
                d4 += d13 * (1.0 + (double)n2 * d16);
                d14 += d15;
                d15 = (double)(2 * i) * d15 * (1.0 - d5) / (double)(2 * i + 1);
                d16 += d17;
                d17 = (double)(2 * i) * d17 * (1.0 - d6) / (double)(2 * i + 1);
                d12 = d12 * ((double)i - 0.5) / ((double)i * (1.0 + d7 * d7 / (double)n));
                d13 = d13 * ((double)i - 0.5) / ((double)i * (1.0 + d8 * d8 / (double)n));
            }
        } else {
            double d18;
            double d19;
            double d20 = Math.sqrt(d7 * d7 + d8 * d8 - 2.0 * d3 * d7 * d8 + (double)n * d9);
            double d21 = d7 * d8 + d3 * (double)n;
            double d22 = d7 * d8 - (double)n;
            double d23 = d7 + d8;
            d4 = Math.atan2(-Math.sqrt(n) * (d22 * d20 + d23 * d21), d22 * d21 - (double)n * d23 * d20) / (Math.PI * 2);
            if (d4 < -1.0000000000000002E-14) {
                d4 += 1.0;
            }
            double d24 = d7 / (Math.PI * 2 * Math.sqrt(n) * (1.0 + d7 * d7 / (double)n));
            double d25 = d8 / (Math.PI * 2 * Math.sqrt(n) * (1.0 + d8 * d8 / (double)n));
            double d26 = d19 = Math.sqrt(d5);
            double d27 = d18 = Math.sqrt(d6);
            for (int i = 1; i <= (n - 1) / 2; ++i) {
                d4 += d24 * (1.0 + (double)n3 * d19);
                d4 += d25 * (1.0 + (double)n2 * d18);
                d26 = (double)(2 * i - 1) * d26 * (1.0 - d5) / (double)(2 * i);
                d19 += d26;
                d27 = (double)(2 * i - 1) * d27 * (1.0 - d6) / (double)(2 * i);
                d18 += d27;
                d24 = d24 * (double)i / (((double)i + 0.5) * (1.0 + d7 * d7 / (double)n));
                d25 = d25 * (double)i / (((double)i + 0.5) * (1.0 + d8 * d8 / (double)n));
            }
        }
        return d4;
    }

    public static double barF(int n, double d, double d2, double d3) {
        double d4 = 1.0 + BiStudentDist.cdf(n, d, d2, d3) - BiStudentDist.cdf(n, 1000.0, d2, d3) - BiStudentDist.cdf(n, d, 1000.0, d3);
        if (d4 < 1.0E-15) {
            return 0.0;
        }
        if (d4 <= 1.0) {
            return d4;
        }
        return 1.0;
    }

    public double[] getMean() {
        return BiStudentDist.getMean(this.nu, this.rho);
    }

    public static double[] getMean(int n, double d) {
        if (n < 1) {
            throw new IllegalArgumentException("nu < 1");
        }
        if (Math.abs(d) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        double[] dArray = new double[]{0.0, 0.0};
        return dArray;
    }

    public double[][] getCovariance() {
        return BiStudentDist.getCovariance(this.nu, this.rho);
    }

    public static double[][] getCovariance(int n, double d) {
        double d2;
        if (n < 1) {
            throw new IllegalArgumentException("nu < 1");
        }
        if (Math.abs(d) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        double[][] dArray = new double[2][2];
        dArray[0][0] = d2 = (double)n / ((double)n - 2.0);
        dArray[0][1] = d2 * d;
        dArray[1][0] = d2 * d;
        dArray[1][1] = d2;
        return dArray;
    }

    public double[][] getCorrelation() {
        return BiStudentDist.getCovariance(this.nu, this.rho);
    }

    public static double[][] getCorrelation(int n, double d) {
        if (n < 1) {
            throw new IllegalArgumentException("nu < 1");
        }
        if (Math.abs(d) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        double[][] dArray = new double[2][2];
        dArray[0][0] = 1.0;
        dArray[0][1] = d;
        dArray[1][0] = d;
        dArray[1][1] = 1.0;
        return dArray;
    }

    protected void setParams(int n, double d) {
        if (n < 1) {
            throw new IllegalArgumentException("nu < 1");
        }
        if (Math.abs(d) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        this.dimension = 2;
        this.nu = n;
        this.rho = d;
        this.facRho = Math.sqrt((1.0 - d) * (1.0 + d));
    }
}

