% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f2S.R
\name{f2S}
\alias{f2S}
\title{Compute the robust effect size index estimate from F-statistic}
\usage{
f2S(f, df, rdf)
}
\arguments{
\item{f}{The F statistic for the parameter of interest.}

\item{df}{Number of degrees of freedom of the chi-square statistic.}

\item{rdf}{Model residual degrees of freedom or number of independent samples.}
}
\value{
Returns a scalar or vector argument of the the robust effect size index estimate.
# to obtain example F values, first fit a glm
mod = glm(charges ~ region * age + bmi + sex, data = RESI::insurance)

# run Anova, using a robust variance-covariance function
# get the F values and Df values
fs = car::Anova(mod, vcov. = sandwich::vcovHC)$F
dfs = car::Anova(mod, vcov. = sandwich::vcovHC)$Df

# get RESI estimates
f2S(fs, df = dfs, rdf = mod$df.residual)
}
\description{
This function computes the robust effect size index from Vandekar, Rao, & Blume (2020).
Vector arguments are accepted. If different length arguments are passed they are dealt with in the usual way of R.
}
\details{
The formula for converting an F statistic to S is:

\eqn{ S = \sqrt(max(0, (f * df * (rdf - 2)/rdf - 1)/rdf))}
}
