% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cop_bootsSE.R
\name{boots}
\alias{boots}
\title{Bootstrapping Standard Errors}
\usage{
boots(bot, y, X, P, param, intercept = NULL, data = NULL)
}
\arguments{
\item{bot}{number of bootstrap replicates.}

\item{y}{the vector or matrix containing the dependent variable.}

\item{X}{the data frame or matrix containing the regressors of the model, both exogeneous and endogeneous. The last column/s should contain the endogeneous variable/s.}

\item{P}{the vector containing the continuous, non-normally distributed endogeneous variable.}

\item{param}{initial values for the parameters to be optimized over. See \code{\link{copulaCorrection}} for more details.}

\item{intercept}{an optional parameter. The model is estimated by default with 
intercept. If no intercept is desired or the regressors matrix \code{X} contains already
a column of ones, intercept should be given the value "no".}

\item{data}{optional data frame or matrix containing the variables of the model.}
}
\value{
Returns the standard errors of the estimates of the model using the copula method 1 described in Park and Gupta (2012). See Details section of \code{\link{copulaCorrection}}.
}
\description{
Performs bootstrapping to obtain the standard errors of the estimates of the model with one continuous endogenous regressor estimated via maximum likelihood
using the \code{\link{copulaCorrection}} function.
}
\details{
The function could be used only when there is a single endogenous regressor and method one is selected in \code{\link{copulaCorrection}}.
of the \code{copulaCorrection} function is used for estimation.
}
\seealso{
\code{\link{copulaCorrection}}
}
