% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exploring.R
\name{mds}
\alias{mds}
\title{mds class}
\usage{
mds(dataset, opt = list(ntree = 1000, mtry = round(sqrt(ncol(dataset) - 2)),
  seed = 1234))
}
\arguments{
\item{dataset}{a n x p dataframe representing the dataset to be used to train the model. The first two columns
must represent respectively the samples names and the class labels related to each sample}

\item{opt}{a list of optional parameters useful to train the random forest. It may include the number
of trees (ntree), the parameter mtry and the seed}
}
\value{
an object of class mds including the following attributes: \itemize{
\item model an object of class random forest containing the proximity matrix
\item classes a factor with the classes associated with each sample, used to train the model
\item sample_names the vector of the names of the samples
}
}
\description{
A constructor function for the S3 class mds; the mds class encapsulates useful information for generating MDS plots
}
\examples{
data(cachexiaData)
params = list(ntree = 1000, mtry = round(sqrt(ncol(cachexiaData) -2)), seed = 1234)
mds_obj <- mds(cachexiaData, opt = params)
}
\author{
Piergiorgio Palla
}

