/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.runframe;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JLabel;

class ReplayPanel
extends JLabel {
    private volatile boolean blink = false;
    private volatile boolean rVisible = true;
    private Thread blinkThread;

    public ReplayPanel() {
        super("R");
        this.setFont(new Font("SansSerif", 1, 50));
        this.setForeground(Color.WHITE);
    }

    public synchronized void setBlink(boolean blink) {
        if (this.blink != blink) {
            if (blink) {
                this.blink = true;
                this.startBlinkThread();
            } else {
                this.blink = false;
                this.stopBlinkThread();
            }
        }
    }

    private void startBlinkThread() {
        this.blinkThread = new Thread(){

            public void run() {
                while (true) {
                    ReplayPanel.this.blink();
                    ReplayPanel.this.repaint();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException exc) {
                        return;
                    }
                }
            }
        };
        this.blinkThread.setDaemon(true);
        this.blinkThread.start();
    }

    private void stopBlinkThread() {
        this.blinkThread.interrupt();
        try {
            this.blinkThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.blinkThread = null;
        this.rVisible = true;
        this.repaint();
    }

    private void blink() {
        this.rVisible = !this.rVisible;
    }

    public void paintComponent(Graphics g) {
        if (this.rVisible) {
            super.paintComponent(g);
        }
    }
}

