/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.permutation;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.module.searchspace.Permutation;
import freak.module.searchspace.PermutationGenotype;

public class Sort_RUN
extends AbstractStaticSingleObjectiveFitnessFunction {
    public Sort_RUN(Schedule schedule) {
        super(schedule);
    }

    protected double evaluate(Genotype genotype) {
        return this.calculateRUN((PermutationGenotype)genotype);
    }

    public String getName() {
        return "Sorting with measure RUN";
    }

    public String getDescription() {
        return "The sorting problem can be viewed as an optimization problem: the sortedness of a sequence has to be maximized. We assume a_1 < a_2 < ... < a_n, so the optimal permutation is the identity. \nThe measure of sortedness used by this fitness function is RUN.\nRUN(pi) is by 1 larger than the number of indices i such that pi(i+1) < pi(i) (number of maximal sorted blocks called runs) leading to a minimization problem.\nIn order to get a maximization problem, the fitness actually returned by this function is -RUN(pi).";
    }

    private int calculateRUN(PermutationGenotype gt) {
        int[] a = gt.getIntArray();
        int count = 0;
        int i = 0;
        while (i < a.length - 1) {
            if (a[i] > a[i + 1]) {
                ++count;
            }
            ++i;
        }
        return -(count + 1);
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        int n = ((Permutation)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        int[] a = new int[n];
        int i = 0;
        while (i < n) {
            a[i] = i;
            ++i;
        }
        return new PermutationGenotype(a);
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        return -1.0;
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return -((Permutation)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return -1.0;
    }
}

