/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.population.Genotype;
import freak.module.fitness.pointset.ResidualHyperPlane;
import freak.module.fitness.pointset.util.ResidualContainer;
import freak.module.searchspace.PointSet;
import freak.module.searchspace.PointSetGenotype;
import java.util.Arrays;

public class LtSOptimization
extends AbstractStaticSingleObjectiveFitnessFunction
implements Configurable {
    private int[] chosenIndices = null;
    private double[] fittedHyperplane = null;
    int offset = -5000;
    String[] ltsFileListCache = null;
    Object[] ltsFileArrayCache = null;
    String m_zName = "LTS (Least Trimmed Squares)";
    String m_zInstanceName = "";
    boolean interceptAdjust = false;
    int h;
    public ResidualContainer[] m_hResiduals = null;

    public LtSOptimization(Schedule schedule) {
        super(schedule);
        if (schedule.getPhenotypeSearchSpace() instanceof PointSet) {
            PointSet ps = (PointSet)schedule.getPhenotypeSearchSpace();
            this.h = this.computeH(ps.getDimension(), ps.getPointDimension());
        }
    }

    private int computeH(int dimension, int pointDimension) {
        double alpha = 0.5;
        return (int)(2.0 * (double)((int)((double)(dimension + pointDimension + 1) / 2.0)) - (double)dimension + 2.0 * alpha * ((double)dimension - (double)((int)((double)(dimension + pointDimension + 1) / 2.0))));
    }

    protected double evaluate(Genotype genotype) {
        PointSet.Point[] supportPoints = ((PointSetGenotype)genotype).getChoosenSubSet();
        PointSet.Point[] allPoints = ((PointSetGenotype)genotype).getPoints();
        int pointDim = ((PointSetGenotype)genotype).getPointDimension();
        int quantile = this.h;
        if (supportPoints.length == 0) {
            return -pointDim + this.offset;
        }
        if (supportPoints.length != supportPoints[0].getDimension()) {
            return -(supportPoints.length - pointDim) + this.offset;
        }
        ResidualHyperPlane hyperPlane = new ResidualHyperPlane(supportPoints);
        this.m_hResiduals = new ResidualContainer[allPoints.length];
        hyperPlane.updateResiduals(this.m_hResiduals, allPoints);
        Arrays.sort(this.m_hResiduals);
        if (this.interceptAdjust) {
            hyperPlane.computeParamLS(allPoints, this.m_hResiduals, quantile);
        }
        double valueOfSolution = 0.0;
        this.chosenIndices = new int[quantile];
        int i = 0;
        while (i < quantile) {
            valueOfSolution += this.m_hResiduals[i].squaredResidual;
            this.chosenIndices[i] = this.m_hResiduals[i].pointIndexInPointSet;
            ++i;
        }
        int dim = hyperPlane.parameter.getDimension();
        this.fittedHyperplane = new double[dim];
        int i2 = 0;
        while (i2 < dim) {
            try {
                this.fittedHyperplane[i2] = hyperPlane.parameter.get(i2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i2;
        }
        return -valueOfSolution;
    }

    public String getShortDescriptionForAdjust() {
        return "Adjust Intercept";
    }

    public String getLongDescriptionForAdjust() {
        return "Whether to perform intercept adjustment at each step.";
    }

    public void setPropertyAdjust(Boolean adjust) {
        this.interceptAdjust = adjust;
    }

    public Boolean getPropertyAdjust() {
        return new Boolean(this.interceptAdjust);
    }

    public String getDescription() {
        return "The fitness value of an individual is the least squares error of the  subset of points represented by the given individual.\n We restrict the search to subsets of size d for d-dimensional points, because they uniquely describe possible solutions.";
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public double getLowerBound() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    public String getName() {
        return String.valueOf(this.m_zName) + (!this.m_zInstanceName.equals("") ? ": " + this.m_zInstanceName : "");
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getShortDescriptionForH() {
        return "h";
    }

    public String getLongDescriptionForH() {
        return "Size of the subset of points.";
    }

    public Integer getPropertyH() {
        return new Integer(this.h);
    }

    public void setPropertyH(Integer H) {
        if (H > 0) {
            this.h = H;
        }
    }

    public int[] getChosenIndices() {
        return this.chosenIndices;
    }

    public double[] getFittedHyperplane() {
        return this.fittedHyperplane;
    }
}

