/*
 * Decompiled with CFR 0.152.
 */
package freak.module.stoppingcriterion;

import freak.core.control.Schedule;
import freak.core.event.GenerationEvent;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.stoppingcriterion.AbstractGenerationStoppingCriterion;

public class OptimumReached
extends AbstractGenerationStoppingCriterion {
    private boolean all;

    public OptimumReached(Schedule schedule) {
        super(schedule);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This module works on single objective fitness functions only.");
        }
        try {
            ((SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction()).getOptimalFitnessValue();
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedEnvironmentException("The stopping criterion can't be applied to the chosen fitness function\n since the optimal fitness value is unknown.");
        }
    }

    public String getName() {
        return "Optimum Reached";
    }

    public String getDescription() {
        return "Stops a run if the optimum is reached.";
    }

    public void checkCriterion(GenerationEvent evt) {
        try {
            IndividualList p = this.getSchedule().getPopulationManager().getPopulation();
            SingleObjectiveFitnessFunction fitnessFunction = (SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction();
            double fitness = 0.0;
            Individual compare = null;
            compare = !this.all ? (p.size() == 1 ? p.getIndividual(0) : p.getIndividualWithRank(1)) : (p.size() == 1 ? p.getIndividual(0) : p.getIndividualWithRank(p.size()));
            fitness = fitnessFunction.evaluate(compare, p);
            if (fitness == fitnessFunction.getOptimalFitnessValue()) {
                this.stopRun();
            }
        }
        catch (UnsupportedOperationException e) {
            throw new RuntimeException("The stopping criterion can't be applied since the fitness function doesn't know its optimum.");
        }
    }

    public void setPropertyAll(Boolean all) {
        this.all = all;
    }

    public Boolean getPropertyAll() {
        return new Boolean(this.all);
    }

    public String getShortDescriptionForAll() {
        return "Whole population";
    }

    public String getLongDescriptionForAll() {
        return "If unchecked, the run is stopped as soon as one individual has reached the optimum.\nIf checked, all individuals have to reach the optimum.";
    }
}

