/*
 * Decompiled with CFR 0.152.
 */
package freak.gui;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import freak.core.control.BatchList;
import freak.core.control.EventController;
import freak.core.graph.Operator;
import freak.core.graph.Port;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Module;
import freak.core.modulesupport.PropertyManager;
import freak.core.modulesupport.inspector.Inspector;
import freak.core.modulesupport.inspector.InspectorVetoException;
import freak.gui.EventTable;
import freak.gui.scheduleeditor.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ConfigurationPanel
extends JPanel {
    private Module activeModule;
    private EventController eventController;
    private JPanel propertyPanel;
    private EventTable eventTable;
    private BatchList batchList;
    private JTabbedPane editingType;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JPanel panelCodeEditing;
    private JPanel panelModule;
    private JTextArea propertyGenerationCode;
    private JScrollPane scrollCode;
    private JScrollPane scrollErrorMsg;
    private JScrollPane scrollEvents;
    private JScrollPane scrollPorts;
    private JScrollPane scrollProperties;
    private JTextArea taDescription;
    private JTextArea taErrorMsg;
    private JTable tablePorts;
    private JTextField tfName;

    public ConfigurationPanel(Module m, EventController eventController, Object[] eventSources, BatchList batchList) {
        this.initComponents();
        this.batchList = batchList;
        this.propertyGenerationCode.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                this.update(arg0.getDocument());
            }

            public void insertUpdate(DocumentEvent arg0) {
                this.update(arg0.getDocument());
            }

            public void removeUpdate(DocumentEvent arg0) {
                this.update(arg0.getDocument());
            }

            private void update(Document d) {
                Interpreter i = new Interpreter();
                i.setStrictJava(true);
                try {
                    i.set("batch", 0);
                    try {
                        i.eval(d.getText(0, d.getLength()));
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    ((TitledBorder)ConfigurationPanel.this.scrollErrorMsg.getBorder()).setTitle("Code compilation successful.");
                    ((TitledBorder)ConfigurationPanel.this.scrollErrorMsg.getBorder()).setTitleColor(Color.gray);
                    ConfigurationPanel.this.taErrorMsg.setText("");
                    ConfigurationPanel.this.panelCodeEditing.updateUI();
                }
                catch (EvalError e) {
                    if (ConfigurationPanel.this.getErrorLine(e) < 0) {
                        ((TitledBorder)ConfigurationPanel.this.scrollErrorMsg.getBorder()).setTitle("Runtime error in unknown line");
                    } else {
                        ((TitledBorder)ConfigurationPanel.this.scrollErrorMsg.getBorder()).setTitle("Error in line: " + ConfigurationPanel.this.getErrorLine(e));
                    }
                    ((TitledBorder)ConfigurationPanel.this.scrollErrorMsg.getBorder()).setTitleColor(Color.red);
                    ConfigurationPanel.this.taErrorMsg.setText(ConfigurationPanel.this.getErrorMessage(e));
                    ConfigurationPanel.this.panelCodeEditing.updateUI();
                }
            }
        });
        if (m != null) {
            this.eventController = eventController;
            this.activeModule = m;
            this.displayModuleInfo();
            if (this.activeModule instanceof Operator && this.hasAnyPortWithDescription((Operator)this.activeModule)) {
                this.displayPortInfo();
            } else {
                this.scrollPorts.setVisible(false);
            }
            if (this.activeModule instanceof Configurable) {
                this.propertyPanel = ((Configurable)this.activeModule).getInspector();
                this.scrollProperties.setViewportView(this.propertyPanel);
            } else {
                this.scrollProperties.setVisible(false);
            }
            if (eventController.hasCustomizableEvents(this.activeModule)) {
                this.eventTable = new EventTable(this.activeModule, eventController, eventSources);
                this.scrollEvents.setViewportView(this.eventTable);
            } else {
                this.scrollEvents.setVisible(false);
            }
            if (this.activeModule instanceof Configurable) {
                this.propertyGenerationCode.setText(batchList.getConfigurationCode((Configurable)this.activeModule));
            }
        } else {
            this.panelModule.setVisible(false);
            this.scrollPorts.setVisible(false);
            this.scrollProperties.setVisible(false);
            this.scrollEvents.setVisible(false);
        }
    }

    private int getErrorLine(EvalError e) {
        try {
            int line = e.getErrorLineNumber();
            if (line >= 0) {
                return line;
            }
        }
        catch (Exception line) {
            // empty catch block
        }
        if (e.getMessage().startsWith("Parse error at line")) {
            try {
                String[] m = e.getMessage().split(" ", 9);
                m[6] = m[6].trim();
                int line = Integer.parseInt(m[4].trim().replaceAll(",", ""));
                return line;
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }
        if (e.getMessage().indexOf("'' Token Parsing Error:") > 0) {
            String[] m = e.getMessage().substring(e.getMessage().indexOf("'' Token Parsing Error:") + 24).split(" ");
            return Integer.parseInt(m[4].trim().replaceAll(",", ""));
        }
        return -1;
    }

    private String getErrorMessage(EvalError e) {
        if (e instanceof TargetError) {
            return ((TargetError)e).getTarget().getLocalizedMessage();
        }
        if (e.getMessage().startsWith("Parse error at line")) {
            String[] m = e.getMessage().split(" ", 9);
            m[6] = m[6].trim();
            String err = m[8].trim();
            return err;
        }
        String m = e.getMessage().trim();
        if (m.indexOf("'' Token Parsing Error:") > 0) {
            return m.substring(m.lastIndexOf("Encountered:"));
        }
        String[] searchStrings = new String[]{"'' :", "'' internal Error:"};
        int start = 0;
        int i = 0;
        while (i < searchStrings.length) {
            String s = searchStrings[i];
            start = Math.max(m.indexOf(s) + s.length(), start);
            ++i;
        }
        return m.substring(start).trim();
    }

    private boolean hasAnyPortWithDescription(Operator operator) {
        int i = 0;
        while (i < operator.getNumberOfInPorts() + operator.getNumberOfOutPorts()) {
            String description = operator.getPortAt(i).getDescription();
            if (description != null && !description.equals("")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void displayModuleInfo() {
        Util.displayText(this.tfName, this.activeModule.getName());
        Util.displayText(this.taDescription, this.activeModule.getDescription());
    }

    private void displayPortInfo() {
        Object[] row;
        Port p;
        Operator g = (Operator)this.activeModule;
        DefaultTableModel tm = new DefaultTableModel(new Object[]{"Port", "Description"}, 0);
        this.tablePorts.setModel(tm);
        TableColumn col = this.tablePorts.getColumnModel().getColumn(0);
        col.setPreferredWidth(col.getMinWidth());
        this.tablePorts.setEnabled(false);
        int i = 0;
        while (i < g.getNumberOfInPorts()) {
            p = g.getPortAt(i);
            if (p.getDescription() != null && !p.getDescription().equals("")) {
                row = new Object[]{"In " + new Integer(i + 1), p.getDescription()};
                tm.addRow(row);
            }
            ++i;
        }
        i = g.getNumberOfInPorts();
        while (i < g.getNumberOfInPorts() + g.getNumberOfOutPorts()) {
            p = g.getPortAt(i);
            if (p.getDescription() != null && !p.getDescription().equals("")) {
                row = new Object[]{"Out " + new Integer(i - g.getNumberOfInPorts() + 1), p.getDescription()};
                tm.addRow(row);
            }
            ++i;
        }
    }

    public void finishEditing() throws InspectorVetoException {
        if (this.propertyPanel != null) {
            ((Inspector)this.propertyPanel).finishEditing();
        }
        if (this.activeModule != null) {
            this.checkCodeEditing();
        }
    }

    private void checkCodeEditing() throws InspectorVetoException {
        Interpreter i = new Interpreter();
        i.setStrictJava(true);
        try {
            i.set("batch", 0);
            String[] pNames = PropertyManager.getListOfPropertyNames(this.activeModule);
            int j = 0;
            while (j < pNames.length) {
                try {
                    i.set(pNames[j], PropertyManager.getProperty(this.activeModule, pNames[j]));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                ++j;
            }
            i.eval(this.propertyGenerationCode.getText());
            j = 0;
            while (j < pNames.length) {
                Class<?> inputClass;
                Class typeClass = PropertyManager.getPropertyType(this.activeModule, pNames[j]);
                if (i.get(pNames[j]) != null && !typeClass.isAssignableFrom(inputClass = i.get(pNames[j]).getClass())) {
                    throw new InspectorVetoException("Wrong property type for property " + pNames[j] + ": " + inputClass.getName() + ".\nShould be " + typeClass.getName() + ".");
                }
                ++j;
            }
            if (this.activeModule instanceof Configurable) {
                this.batchList.setConfigurationCode((Configurable)this.activeModule, this.propertyGenerationCode.getText());
            }
        }
        catch (EvalError e) {
            throw new InspectorVetoException("Code Error in line: " + this.getErrorLine(e));
        }
    }

    public Module getConfiguredModule() {
        return this.activeModule;
    }

    private void initComponents() {
        this.scrollEvents = new JScrollPane();
        this.panelModule = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.taDescription = new JTextArea();
        this.tfName = new JTextField();
        this.scrollPorts = new JScrollPane();
        this.tablePorts = new JTable();
        this.editingType = new JTabbedPane();
        this.scrollProperties = new JScrollPane();
        this.panelCodeEditing = new JPanel();
        this.scrollCode = new JScrollPane();
        this.propertyGenerationCode = new JTextArea();
        this.scrollErrorMsg = new JScrollPane();
        this.taErrorMsg = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.scrollEvents.setBorder(new TitledBorder("Events"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.scrollEvents, gridBagConstraints);
        this.panelModule.setLayout(new GridBagLayout());
        this.panelModule.setBorder(new TitledBorder("Module-Information"));
        this.panelModule.setMinimumSize(new Dimension(0, 100));
        this.panelModule.setPreferredSize(new Dimension(0, 100));
        this.jLabel2.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.panelModule.add((Component)this.jLabel2, gridBagConstraints);
        this.taDescription.setEditable(false);
        this.taDescription.setLineWrap(true);
        this.taDescription.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.taDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelModule.add((Component)this.jScrollPane1, gridBagConstraints);
        this.tfName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panelModule.add((Component)this.tfName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.panelModule, gridBagConstraints);
        this.scrollPorts.setBorder(new TitledBorder("Port Descriptions"));
        this.scrollPorts.setMinimumSize(new Dimension(0, 80));
        this.scrollPorts.setPreferredSize(new Dimension(0, 80));
        this.scrollPorts.setViewportView(this.tablePorts);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.scrollPorts, gridBagConstraints);
        this.editingType.addTab("Static Editing", this.scrollProperties);
        this.panelCodeEditing.setLayout(new BorderLayout());
        this.scrollCode.setBorder(new TitledBorder("Property Generation Code"));
        this.scrollCode.setViewportView(this.propertyGenerationCode);
        this.panelCodeEditing.add((Component)this.scrollCode, "Center");
        this.scrollErrorMsg.setBorder(new TitledBorder(null, "Error compiling Code", 0, 0, new Font("Dialog", 1, 12), Color.red));
        this.taErrorMsg.setWrapStyleWord(true);
        this.taErrorMsg.setLineWrap(true);
        this.taErrorMsg.setEditable(false);
        this.taErrorMsg.setRows(4);
        this.taErrorMsg.setBorder(null);
        this.scrollErrorMsg.setViewportView(this.taErrorMsg);
        this.panelCodeEditing.add((Component)this.scrollErrorMsg, "South");
        this.editingType.addTab("Code Editing", this.panelCodeEditing);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.2;
        this.add((Component)this.editingType, gridBagConstraints);
    }
}

