/*
 * Decompiled with CFR 0.152.
 */
package freak.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpWindow
extends JFrame {
    private static final String BASE = "/freak/gui/help/";
    public static final String INDEX_PAGE = "index.html";
    private static final Icon backIcon = new ImageIcon(HelpWindow.class.getResource("/toolbarButtonGraphics/navigation/Back24.gif"));
    private static final Icon forwardIcon = new ImageIcon(HelpWindow.class.getResource("/toolbarButtonGraphics/navigation/Forward24.gif"));
    private static final Icon indexIcon = new ImageIcon(HelpWindow.class.getResource("/toolbarButtonGraphics/navigation/Home24.gif"));
    private Stack backBuffer = new Stack();
    private Stack forwardBuffer = new Stack();
    private URL currentURL;
    private JButton back = new JButton(backIcon);
    private JButton forward = new JButton(forwardIcon);
    private JButton index = new JButton(indexIcon);
    private JLabel addressLabel = new JLabel("Address:");
    private JTextField address = new JTextField();
    private JEditorPane htmlView = new JEditorPane();

    public HelpWindow(Dialog owner) {
        this.initComponents();
    }

    public HelpWindow(Frame owner) {
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle("FrEAK - Help");
        JScrollPane scrollPane = new JScrollPane();
        JToolBar topPanel = new JToolBar();
        scrollPane.setPreferredSize(new Dimension(800, 600));
        this.htmlView.setEditable(false);
        topPanel.setFloatable(false);
        GridBagLayout topLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(6, 12, 5, 0);
        topLayout.setConstraints(this.back, c);
        c = new GridBagConstraints();
        c.insets = new Insets(6, 2, 5, 0);
        topLayout.setConstraints(this.forward, c);
        c = new GridBagConstraints();
        c.insets = new Insets(6, 5, 5, 0);
        topLayout.setConstraints(this.index, c);
        c = new GridBagConstraints();
        c.insets = new Insets(6, 17, 6, 0);
        topLayout.setConstraints(this.addressLabel, c);
        c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(6, 11, 5, 11);
        topLayout.setConstraints(this.address, c);
        topPanel.setLayout(topLayout);
        scrollPane.setBorder(new EmptyBorder(0, 0, 18, 0));
        this.htmlView.setBorder(new EmptyBorder(12, 12, 12, 12));
        topPanel.add(this.back);
        topPanel.add(this.forward);
        topPanel.add(this.index);
        topPanel.add(this.addressLabel);
        topPanel.add(this.address);
        this.getContentPane().add(scrollPane);
        this.getContentPane().add((Component)topPanel, "North");
        scrollPane.setViewportView(this.htmlView);
        this.htmlView.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HelpWindow.this.goToAbsolutePage(e.getURL());
                }
            }
        });
        this.back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpWindow.this.back();
            }
        });
        this.forward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpWindow.this.forward();
            }
        });
        this.index.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpWindow.this.goToPage(HelpWindow.INDEX_PAGE);
            }
        });
        this.address.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpWindow.this.goToAbsolutePage(HelpWindow.this.address.getText());
            }
        });
        this.back.setEnabled(false);
        this.forward.setEnabled(false);
    }

    public void goToPage(String page) {
        URL url;
        String absolutePage = BASE + page;
        int anchorSeparator = absolutePage.indexOf(35);
        if (anchorSeparator != -1) {
            String resource = absolutePage.substring(0, anchorSeparator);
            String anchor = absolutePage.substring(anchorSeparator);
            try {
                url = new URL(HelpWindow.class.getResource(resource) + anchor);
            }
            catch (MalformedURLException exc) {
                url = null;
            }
        } else {
            url = HelpWindow.class.getResource(absolutePage);
        }
        if (url != null) {
            this.goToAbsolutePage(url);
        } else {
            this.htmlView.setEditorKit(this.htmlView.getEditorKitForContentType("text/plain"));
            this.htmlView.setDocument(this.htmlView.getEditorKit().createDefaultDocument());
            this.htmlView.setText("The help pages cannot be found. You might try to reinstall FrEAK.\n\nMissing Page was:\n" + absolutePage);
        }
    }

    private void forward() {
        this.backBuffer.push(this.currentURL);
        this.currentURL = (URL)this.forwardBuffer.pop();
        this.displayPage();
    }

    private void back() {
        this.forwardBuffer.push(this.currentURL);
        this.currentURL = (URL)this.backBuffer.pop();
        this.displayPage();
    }

    private void goToAbsolutePage(String page) {
        try {
            URL url = new URL(page);
            this.goToAbsolutePage(url);
        }
        catch (MalformedURLException exc) {
            this.htmlView.setEditorKit(this.htmlView.getEditorKitForContentType("text/plain"));
            this.htmlView.setDocument(this.htmlView.getEditorKit().createDefaultDocument());
            this.htmlView.setText("Malformed URL:\n" + page);
        }
    }

    private void goToAbsolutePage(URL url) {
        if (this.currentURL != null && !this.currentURL.equals(url)) {
            this.backBuffer.push(this.currentURL);
            this.forwardBuffer.clear();
        }
        this.currentURL = url;
        this.displayPage();
    }

    private void displayPage() {
        this.address.setText(String.valueOf(this.currentURL));
        try {
            this.htmlView.setPage(this.currentURL);
        }
        catch (IOException exc) {
            this.htmlView.setEditorKit(this.htmlView.getEditorKitForContentType("text/plain"));
            this.htmlView.setDocument(this.htmlView.getEditorKit().createDefaultDocument());
            this.htmlView.setText("Unavailable Page:\n" + this.currentURL);
        }
        this.checkEnable();
    }

    private void checkEnable() {
        this.forward.setEnabled(!this.forwardBuffer.isEmpty());
        this.back.setEnabled(!this.backBuffer.isEmpty());
    }
}

