/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.generalstring;

import freak.core.modulesupport.inspector.Inspector;
import freak.module.fitness.generalstring.Champ;
import freak.module.searchspace.GeneralString;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;

public class ChampInspector
extends Inspector {
    Champ function;
    JTextField clubField;
    JTable scoreTab;
    JTable startScoreTab;
    JTable matchTab;

    public ChampInspector(Champ function) {
        super(function);
        this.function = function;
        this.setLayout(new BorderLayout(10, 10));
        JPanel top = new JPanel();
        top.setLayout(new FlowLayout());
        top.add(new JLabel("No of clubs: "));
        JPanel topest = new JPanel();
        topest.setLayout(new BorderLayout());
        JCheckBox random = new JCheckBox("Create Randomly", (boolean)function.getPropertyRandomly());
        random.addActionListener(new CheckBoxListener());
        topest.add((Component)random, "North");
        topest.add((Component)top, "South");
        this.add((Component)topest, "North");
        this.clubField = new JTextField(Integer.toString(function.getPropertyScore().length));
        this.clubField.setMinimumSize(new Dimension(50, 20));
        this.clubField.setPreferredSize(new Dimension(50, 20));
        ClubFieldListener listener = new ClubFieldListener();
        this.clubField.addActionListener(listener);
        this.clubField.addFocusListener(listener);
        top.add(this.clubField);
        this.scoreTab = new JTable(3, 2);
        ScoreTable scoreTableModel = new ScoreTable();
        this.scoreTab.setModel(scoreTableModel);
        top.add(this.scoreTab);
        this.startScoreTab = new JTable();
        this.startScoreTab.setModel(new StartScoreTable());
        this.add((Component)this.startScoreTab, "Center");
        this.matchTab = new JTable();
        this.matchTab.setModel(new MatchTable());
        this.add((Component)this.matchTab, "South");
        if (random.isSelected()) {
            this.startScoreTab.setEnabled(false);
            this.startScoreTab.setVisible(false);
            this.matchTab.setEnabled(false);
            this.matchTab.setVisible(false);
        }
    }

    class ScoreTable
    extends AbstractTableModel {
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return 3;
        }

        public Object getValueAt(int row, int col) {
            if (col == 0 && row == 0) {
                return "win";
            }
            if (col == 0 && row == 1) {
                return "lose";
            }
            if (col == 0 && row == 2) {
                return "draw";
            }
            if (col == 1) {
                return Integer.toString(ChampInspector.this.function.getPropertyRule()[row]);
            }
            return null;
        }

        public void setValueAt(Object obj, int row, int col) {
            int[] rule = ChampInspector.this.function.getPropertyRule();
            Integer value = new Integer(0);
            try {
                value = new Integer((String)obj);
                rule[row] = value >= 0 ? value : 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ChampInspector.this.function.setPropertyRule(rule);
            this.fireTableCellUpdated(row, col);
        }
    }

    class StartScoreTable
    extends AbstractTableModel {
        public boolean isCellEditable(int row, int col) {
            return col == 1 && row >= 1;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return ChampInspector.this.function.getPropertyScore().length + 1;
        }

        public Object getValueAt(int row, int col) {
            if (col == 0 && row == 0) {
                return "club";
            }
            if (col == 1 && row == 0) {
                return "score";
            }
            if (col == 0 && row >= 1) {
                return Integer.toString(row - 1);
            }
            if (col == 1 && row >= 1) {
                return Integer.toString(ChampInspector.this.function.getPropertyScore()[row - 1]);
            }
            return null;
        }

        public void setValueAt(Object obj, int row, int col) {
            int[] score = ChampInspector.this.function.getPropertyScore();
            Integer value = new Integer(0);
            try {
                value = new Integer((String)obj);
                score[row - 1] = value >= 0 ? value : 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ChampInspector.this.function.setPropertyScore(score);
            this.fireTableCellUpdated(row, col);
        }
    }

    class MatchTable
    extends AbstractTableModel {
        public boolean isCellEditable(int row, int col) {
            return col >= 1 && row >= 1;
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return ((GeneralString)ChampInspector.this.function.getSchedule().getPhenotypeSearchSpace()).getDimension() + 1;
        }

        public Object getValueAt(int row, int col) {
            if (col == 0 && row == 0) {
                return "match";
            }
            if (col == 1 && row == 0) {
                return "club 1";
            }
            if (col == 2 && row == 0) {
                return "club 2";
            }
            if (col == 0 && row >= 1) {
                return Integer.toString(row - 1);
            }
            if (col == 1 && row >= 1) {
                return Integer.toString(ChampInspector.this.function.getPropertyMatch()[row - 1][0]);
            }
            if (col == 2 && row >= 1) {
                return Integer.toString(ChampInspector.this.function.getPropertyMatch()[row - 1][1]);
            }
            return null;
        }

        public void setValueAt(Object obj, int row, int col) {
            int[][] match = ChampInspector.this.function.getPropertyMatch();
            Integer value = new Integer(0);
            try {
                value = new Integer((String)obj);
                int realValue = value;
                if (realValue < 0) {
                    realValue = 0;
                }
                if (realValue > ChampInspector.this.function.getPropertyScore().length - 1) {
                    realValue = ChampInspector.this.function.getPropertyScore().length - 1;
                }
                match[row - 1][col - 1] = realValue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ChampInspector.this.function.setPropertyMatch(match);
            this.fireTableCellUpdated(row, col);
        }
    }

    class ClubFieldListener
    implements ActionListener,
    FocusListener {
        ClubFieldListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int i;
            Integer value = new Integer(0);
            int realValue = 0;
            try {
                JTextField textField = (JTextField)e.getSource();
                value = new Integer(textField.getText());
                realValue = value;
                if (realValue < 0) {
                    textField.setText(Integer.toString(ChampInspector.this.function.getPropertyRule().length));
                }
            }
            catch (NumberFormatException textField) {
                // empty catch block
            }
            int diff = realValue - ChampInspector.this.function.getPropertyScore().length;
            int[] score = ChampInspector.this.function.getPropertyScore();
            int[] newScore = new int[realValue];
            if (diff >= 0) {
                i = 0;
                while (i < score.length) {
                    newScore[i] = score[i];
                    ++i;
                }
            }
            if (diff < 0) {
                i = 0;
                while (i < newScore.length) {
                    newScore[i] = score[i];
                    ++i;
                }
            }
            ChampInspector.this.function.setPropertyScore(newScore);
            ChampInspector.this.startScoreTab.setAutoResizeMode(2);
            int[][] match = ChampInspector.this.function.getPropertyMatch();
            int i2 = 0;
            while (i2 < match.length) {
                if (match[i2][0] > realValue) {
                    match[i2][0] = realValue - 1;
                }
                if (match[i2][1] > realValue) {
                    match[i2][1] = realValue - 1;
                }
                ++i2;
            }
            ChampInspector.this.function.setPropertyMatch(match);
            ChampInspector.this.repaint();
        }

        public void focusLost(FocusEvent e) {
            this.actionPerformed(new ActionEvent(ChampInspector.this.clubField, 1001, "manual"));
        }

        public void focusGained(FocusEvent e) {
        }
    }

    class CheckBoxListener
    implements ActionListener {
        CheckBoxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean checked;
            boolean bl = checked = ChampInspector.this.function.getPropertyRandomly() == false;
            if (checked) {
                ChampInspector.this.startScoreTab.setEnabled(false);
                ChampInspector.this.startScoreTab.setVisible(false);
                ChampInspector.this.matchTab.setEnabled(false);
                ChampInspector.this.matchTab.setVisible(false);
            } else {
                ChampInspector.this.startScoreTab.setEnabled(true);
                ChampInspector.this.startScoreTab.setVisible(true);
                ChampInspector.this.matchTab.setEnabled(true);
                ChampInspector.this.matchTab.setVisible(true);
            }
            ChampInspector.this.function.setPropertyRandomly(new Boolean(checked));
        }
    }
}

