/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer.isingmodelcliques;

import freak.core.control.Schedule;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.AbstractObserver;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.module.fitness.generalstring.IsingModelCliques;
import freak.module.searchspace.GeneralStringGenotype;

public class CliquesMonochromaticBridges
extends AbstractObserver
implements IndividualListEventListener,
Configurable {
    public CliquesMonochromaticBridges(Schedule schedule) {
        super(schedule);
        this.setMeasure(1);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        if (!(schedule.getRealFitnessFunction() instanceof IsingModelCliques)) {
            throw new UnsupportedEnvironmentException("This module works on Ising Model Cliques only.");
        }
    }

    public String getName() {
        return "Cliques Monochromatic Bridge Rate";
    }

    public String getDescription() {
        return "Computes the rate of monochromatic bridges.";
    }

    public Class getOutputDataType() {
        return double[].class;
    }

    public void individualList(IndividualListEvent evt) {
        IndividualList individualList = evt.getIndividualList();
        Individual[] individuals = individualList.toArray();
        double[] result = new double[individuals.length];
        int i = 0;
        while (i < individuals.length) {
            result[i] = this.computePotentialFunction(individuals[i]);
            ++i;
        }
        this.updateViews(result);
    }

    public double computePotentialFunction(Individual individual) {
        int result = 0;
        int[] genotype = ((GeneralStringGenotype)individual.getGenotype()).getIntArray();
        IsingModelCliques fitness = (IsingModelCliques)this.getSchedule().getRealFitnessFunction();
        int[][] bridges = fitness.getBridges();
        int i = 0;
        while (i < bridges.length) {
            if (genotype[bridges[i][0]] == genotype[bridges[i][1]]) {
                ++result;
            }
            ++i;
        }
        return (double)result / (double)bridges.length;
    }

    public void createEvents() {
        super.createEvents();
        this.getSchedule().getEventController().addEvent(this, "Get individuals from", IndividualListEvent.class, this.getSchedule().getPopulationManager());
    }
}

