/*
 * Decompiled with CFR 0.152.
 */
package freak.module.parametercontroller;

import freak.core.event.EventListener;
import freak.core.event.GenerationEvent;
import freak.core.event.GenerationEventListener;
import freak.core.event.RunEvent;
import freak.core.event.RunEventListener;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.Configurable;
import freak.core.parametercontroller.AbstractParameterController;

public abstract class AbstractCyclicRotation
extends AbstractParameterController
implements GenerationEventListener,
RunEventListener,
Configurable {
    protected static final String NAME_VALUE = "Value";
    protected double lower;
    protected double upper;
    protected double current;
    protected double delta;

    public AbstractCyclicRotation(OperatorGraph opGraph) {
        super(opGraph);
        this.addParameter(NAME_VALUE, Double.class);
    }

    public Double getPropertyDelta() {
        return new Double(this.delta);
    }

    public void setPropertyDelta(Double d) {
        this.delta = d;
    }

    public Double getPropertyLower() {
        return new Double(this.lower);
    }

    public void setPropertyLower(Double l) {
        this.lower = l;
    }

    public String getShortDescriptionForLower() {
        return "Lower bound";
    }

    public String getLongDescriptionForLower() {
        return "The lower bound for the value of the controlled properties.";
    }

    public Double getPropertyUpper() {
        return new Double(this.upper);
    }

    public void setPropertyUpper(Double u) {
        this.upper = u;
    }

    public String getShortDescriptionForUpper() {
        return "Upper bound";
    }

    public String getLongDescriptionForUpper() {
        return "The upper bound for the value of the controlled properties.";
    }

    public String getName() {
        return "Cyclic Rotation";
    }

    public String getDescription() {
        return "Rotates the values of the controlled properties cyclically inside an interval specified by a lower and an upper bound.";
    }

    public abstract void generation(GenerationEvent var1);

    public void runStarted(RunEvent evt) {
        this.current = this.lower;
    }

    public void createEvents() {
        this.getSchedule().getEventController().addEvent((EventListener)this, GenerationEvent.class, this.getSchedule());
        this.getSchedule().getEventController().addEvent((EventListener)this, RunEvent.class, this.getSchedule());
    }
}

