/*
 * Decompiled with CFR 0.152.
 */
package freak.core.view.swingsupport;

import freak.core.view.swingsupport.FreakSwingModel;
import freak.core.view.swingsupport.UpdateManager;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JSlider;

public class FreakSliderModel
implements FreakSwingModel {
    private transient JSlider slider;
    private boolean programmaticalChange;
    private int value;
    private int minimum;
    private int maximum;
    private boolean autoTicks;

    public void setView(JSlider view) {
        this.slider = view;
        this.flush();
    }

    public void setValue(int value) {
        this.value = value;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    public boolean isProgrammaticalChange() {
        return this.programmaticalChange;
    }

    public void setAutoTicks(boolean b) {
        this.autoTicks = b;
    }

    public void flush() {
        if (this.slider == null) {
            return;
        }
        if (this.slider.getValueIsAdjusting()) {
            UpdateManager.markDirty(this);
            return;
        }
        this.programmaticalChange = true;
        if (this.autoTicks) {
            this.slider.setPaintTicks(false);
            this.slider.setPaintLabels(false);
            this.slider.getModel().setMinimum(this.minimum);
            this.slider.getModel().setMaximum(this.maximum);
            this.slider.getModel().setValue(this.value);
            this.createTicks();
            this.slider.setPaintTicks(true);
            this.slider.setPaintLabels(true);
        } else {
            this.slider.setMinimum(this.minimum);
            this.slider.setMaximum(this.maximum);
            this.slider.setValue(this.value);
        }
        this.programmaticalChange = false;
    }

    private void createTicks() {
        int n = this.maximum;
        int k = 1;
        while (n > 9) {
            k *= 5;
            if ((n /= 5) <= 9) continue;
            n /= 2;
            k *= 2;
        }
        int lastMajorLabel = this.maximum - (this.maximum - this.minimum) % k;
        if (this.slider.getMajorTickSpacing() != k || this.slider.getLabelTable().get(new Integer(lastMajorLabel)) == null) {
            this.slider.setMinorTickSpacing(Math.max(1, k / 10));
            this.slider.setMajorTickSpacing(k);
            Hashtable<Integer, JComponent> labelTable = this.slider.createStandardLabels(k, this.minimum);
            this.slider.setLabelTable(labelTable);
        }
    }
}

