/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.bitstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class LeadingOnes
extends AbstractStaticSingleObjectiveFitnessFunction {
    public LeadingOnes(Schedule schedule) {
        super(schedule);
    }

    public double evaluate(Genotype genotype) {
        int number = 0;
        BitSet set = ((BitStringGenotype)genotype).getBitSet();
        int dimension = ((BitString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
        int k = 0;
        while (k < dimension) {
            if (set.get(k)) {
                ++number;
            } else {
                return number;
            }
            ++k;
        }
        return number;
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        return ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        int dimension = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        BitSet bs = new BitSet(dimension);
        bs.set(0, dimension);
        return new BitStringGenotype(bs, dimension);
    }

    public String getDescription() {
        return "The number of leading ones or the length of the largest coherent block of ones from the first position in the bit string corresponds to the fitness value.";
    }

    public String getName() {
        return "LeadingOnes";
    }
}

