/*
 * Decompiled with CFR 0.152.
 */
package freak.core.control;

import freak.core.control.Actions;
import freak.core.control.Freak;
import freak.core.control.FreakFile;
import freak.core.control.Replay;
import freak.core.control.RunControl;
import freak.core.control.Schedule;
import freak.core.control.StateListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class BatchProcessor
implements StateListener {
    private RunControl runControl;
    private File loadFile;
    private File saveFile;
    private File[] tempFiles;
    private int nextTempFile;
    private long lastSave;
    private long saveInterval;

    public BatchProcessor(File loadFile, File saveFile, File[] tempFiles, long saveInterval) {
        this.loadFile = loadFile;
        this.saveFile = saveFile;
        this.tempFiles = tempFiles;
        this.saveInterval = saveInterval;
    }

    public void run() throws FileNotFoundException, IOException, ClassNotFoundException {
        this.runControl = new RunControl(this);
        Freak.debug("Trying to read " + this.loadFile, 2);
        FreakFile file = FreakFile.read(new FileInputStream(this.loadFile));
        this.runControl.fromFile(file);
        this.lastSave = System.currentTimeMillis();
        Freak.debug("Read successfull " + this.loadFile, 2);
        Freak.debug("Starting " + this.loadFile, 2);
        this.runControl.request(new Actions.StartAction());
    }

    public void asynchroneousFeedback(Schedule schedule, Replay replay) {
        if (this.tempFiles == null) {
            return;
        }
        try {
            long now = System.currentTimeMillis();
            if (now - this.lastSave > this.saveInterval) {
                FreakFile currentState = new FreakFile(replay, schedule);
                File tempFile = this.tempFiles[this.nextTempFile];
                Freak.debug("Writing backup to " + tempFile, 1);
                currentState.write(new FileOutputStream(tempFile));
                this.nextTempFile = (this.nextTempFile + 1) % this.tempFiles.length;
                this.lastSave = now;
            }
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public void synchroneousFeedback(Schedule activeSchedule, Replay replay) {
    }

    public void simulationCompleted(Actions.Action lastProcessed) {
        Freak.debug("Run ended " + this.loadFile, 2);
        try {
            try {
                if (this.saveFile != null) {
                    FreakFile save = this.runControl.toFile();
                    save.write(new FileOutputStream(this.saveFile));
                    Freak.debug("Results written to " + this.saveFile, 1);
                }
            }
            catch (IOException exc) {
                exc.printStackTrace();
                this.runControl.request(new Actions.TerminateAction());
            }
        }
        finally {
            this.runControl.request(new Actions.TerminateAction());
        }
    }

    public void simulationException(Exception exc) {
        this.saveFile = null;
        exc.printStackTrace();
    }

    public void terminated(Actions.Action lastProcessedBeforeTermination) {
        Freak.debug("Bye", 4);
        System.exit(0);
    }
}

