/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.scheduleeditor;

import freak.core.control.Batch;
import freak.core.control.BatchList;
import freak.core.fitness.FitnessFunction;
import freak.core.graph.Initialization;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Module;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.searchspace.SearchSpace;
import freak.gui.scheduleeditor.BatchTable;
import freak.gui.scheduleeditor.BatchTableModel;
import freak.gui.scheduleeditor.ScheduleEditor;
import freak.gui.scheduleeditor.ScheduleEditorPanel;
import freak.gui.scheduleeditor.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PanelBatches
extends ScheduleEditorPanel {
    private BatchTable batchTable;
    private BatchList batchList;
    private JButton buBatchMoveDown;
    private JButton buBatchMoveUp;
    private JButton buConfigFitnessFunction;
    private JButton buConfigInitializationOperator;
    private JButton buConfigSearchSpace;
    private JButton buCopyBatch;
    private JButton buDeleteBatch;
    private JButton buNewBatch;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel12;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel6;
    private JScrollPane scrollBatchTable;
    private JSpinner spinnerNumberOfRuns;
    private JTextField tfFitnessInstance;
    private JTextField tfPopulation;
    private JTextField tfSearchSpace;

    public PanelBatches(ScheduleEditor scheduleEditor) {
        super(scheduleEditor);
        this.initComponents();
        this.batchList = this.schedule.getBatchList();
        this.initTable();
        this.initSpinner();
    }

    public static String getDescription() {
        return "Create Batches of Runs";
    }

    public String getHelpURL() {
        return "node4.html#SECTION00452000000000000000";
    }

    public boolean mayAdvance() {
        return this.batchList.size() >= 1;
    }

    public void enter() {
        super.enter();
        if (this.schedule.getBatchList().size() == 0) {
            this.scheduleDependencyChecker.createDefaultBatchList();
            this.parse();
        }
    }

    private void initTable() {
        this.batchTable = new BatchTable(this.schedule);
        this.batchTable.changeSelection(Math.max(this.schedule.getCurrentBatch() - 1, 0), 0, false, false);
        this.parse();
        this.scrollBatchTable.setViewportView(this.batchTable);
        ListSelectionModel rowSM = this.batchTable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PanelBatches.this.tableBatchesValueChanged(e);
            }
        });
    }

    public void initSpinner() {
        this.spinnerNumberOfRuns.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PanelBatches.this.spinnerNumberOfRunsStateChanged(e);
            }
        });
    }

    private void parse() {
        int selectedRow = this.batchTable.getSelectedRow();
        this.buCopyBatch.setEnabled(selectedRow >= 0 && selectedRow < this.batchList.size());
        this.buDeleteBatch.setEnabled(!this.isBatchFixed(selectedRow));
        this.buBatchMoveUp.setEnabled(!this.isBatchFixed(selectedRow) && !this.isBatchFixed(selectedRow - 1));
        this.buBatchMoveDown.setEnabled(!this.isBatchFixed(selectedRow) && !this.isBatchFixed(selectedRow + 1));
        if (selectedRow == -1 || selectedRow >= this.batchList.size()) {
            Util.displayText(this.tfSearchSpace, "<no batch selected>");
            Util.displayText(this.tfFitnessInstance, "<no batch selected>");
            Util.displayText(this.tfPopulation, "<no batch selected>");
            this.spinnerNumberOfRuns.setValue(new Integer(0));
            this.spinnerNumberOfRuns.setEnabled(false);
            this.buConfigSearchSpace.setEnabled(false);
            this.buConfigFitnessFunction.setEnabled(false);
            this.buConfigInitializationOperator.setEnabled(false);
        } else {
            Batch selectedBatch = this.batchList.get(selectedRow);
            Util.displayText(this.tfSearchSpace, (String)this.batchTable.getValueAt(selectedRow, 1));
            Util.displayText(this.tfFitnessInstance, (String)this.batchTable.getValueAt(selectedRow, 2));
            Util.displayText(this.tfPopulation, (String)this.batchTable.getValueAt(selectedRow, 3));
            this.spinnerNumberOfRuns.setValue(this.batchTable.getValueAt(selectedRow, 0));
            this.spinnerNumberOfRuns.setEnabled(!selectedBatch.isFinished());
            if (selectedBatch.isStarted()) {
                this.buConfigSearchSpace.setEnabled(false);
                this.buConfigFitnessFunction.setEnabled(false);
                this.buConfigInitializationOperator.setEnabled(false);
            } else {
                this.buConfigSearchSpace.setEnabled(this.schedule.getPhenotypeSearchSpace() instanceof Configurable);
                this.buConfigFitnessFunction.setEnabled(this.schedule.getRealFitnessFunction() instanceof Configurable);
                this.buConfigInitializationOperator.setEnabled(this.schedule.getInitialization() instanceof Configurable);
            }
        }
    }

    private boolean isBatchFixed(int batchIndex) {
        if (batchIndex < 0 || batchIndex >= this.batchList.size()) {
            return true;
        }
        return this.schedule.getBatchList().get(batchIndex).isStarted();
    }

    private void configureBatchModule(Configurable module, int row) {
        Batch batch = this.batchList.get(row);
        boolean batchLoadingSuccessful = true;
        Batch backupBatch = this.schedule.createBatchFromCurrentConfigurations();
        try {
            batch.applyAllConfigurations();
            for (Module mod : this.schedule.getAllModules()) {
                mod.testSchedule(this.schedule);
                mod.initialize();
            }
        }
        catch (UnsupportedEnvironmentException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.scheduleEditor, "The current batch is invalid and cannot be run.", "Invalid Batch", 0);
            this.processInvalidBatch(row);
            batchLoadingSuccessful = false;
        }
        if (batchLoadingSuccessful) {
            try {
                Util.configureModule(this.scheduleEditor, module, this.schedule);
                for (Module mod : this.schedule.getAllModules()) {
                    mod.testSchedule(this.schedule);
                    mod.initialize();
                }
                Batch newBatch = this.schedule.createBatchFromCurrentConfigurations();
                newBatch.applyAllConfigurations();
                newBatch = this.schedule.createBatchFromCurrentConfigurations();
                newBatch.setRuns(batch.getRuns());
                this.batchList.set(row, newBatch);
            }
            catch (UnsupportedEnvironmentException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.scheduleEditor, "The configured module cannot be used within the current batch.\nThe batch is removed from the schedule.", "Invalid Module Configuration", 0);
                this.processInvalidBatch(row);
            }
        }
        try {
            ((BatchTableModel)this.batchTable.getModel()).fireTableCellUpdated(row, 1);
            ((BatchTableModel)this.batchTable.getModel()).fireTableCellUpdated(row, 2);
            ((BatchTableModel)this.batchTable.getModel()).fireTableCellUpdated(row, 3);
            backupBatch.applyAllConfigurations();
            for (Module mod : this.schedule.getAllModules()) {
                mod.testSchedule(this.schedule);
                mod.initialize();
            }
        }
        catch (UnsupportedEnvironmentException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.scheduleEditor, "The current batch is invalid and thus removed from the schedule.", "Invalid Batch", 0);
            this.processInvalidBatch(row);
        }
        this.parse();
    }

    private void checkBatch(int row) {
        Batch batch = this.batchList.get(row);
        Batch backupBatch = this.schedule.createBatchFromCurrentConfigurations();
        try {
            batch.applyAllConfigurations();
            for (Module mod : this.schedule.getAllModules()) {
                mod.testSchedule(this.schedule);
                mod.initialize();
            }
        }
        catch (UnsupportedEnvironmentException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.scheduleEditor, "The current batch is invalid and cannot be run.", "Invalid Batch", 0);
            this.processInvalidBatch(row);
        }
        try {
            backupBatch.applyAllConfigurations();
            for (Module mod : this.schedule.getAllModules()) {
                mod.testSchedule(this.schedule);
                mod.initialize();
            }
        }
        catch (UnsupportedEnvironmentException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.scheduleEditor, "The current batch is invalid and thus removed from the schedule.", "Invalid Batch", 0);
            this.processInvalidBatch(row);
        }
    }

    private void processInvalidBatch(int row) {
        this.batchTable.deleteRow(row);
        this.batchTable.changeSelection(row == 0 ? 0 : row - 1, 0, false, false);
        this.scheduleEditor.updateComponents();
    }

    private void tableBatchesValueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.parse();
    }

    private void spinnerNumberOfRunsStateChanged(ChangeEvent evt) {
        if (this.batchTable.getSelectionModel().isSelectionEmpty()) {
            this.spinnerNumberOfRuns.setValue(new Integer(0));
        } else {
            int newValue = (Integer)this.spinnerNumberOfRuns.getValue();
            int lowerBound = 1;
            int batchNum = this.batchTable.getSelectedRow();
            Batch selectedBatch = this.schedule.getBatchList().get(batchNum);
            if (selectedBatch.isFinished()) {
                Batch batch = this.batchList.get(batchNum);
                this.spinnerNumberOfRuns.setValue(new Integer(batch.getRuns()));
                return;
            }
            if (selectedBatch.isStarted()) {
                lowerBound = this.schedule.getCurrentRun();
            }
            if (newValue < lowerBound) {
                this.spinnerNumberOfRuns.setValue(new Integer(lowerBound));
                newValue = lowerBound;
            }
            Batch b = this.batchList.get(this.batchTable.getSelectedRow());
            b.setRuns(newValue);
            this.schedule.getDefaultBatch().setRuns(newValue);
            ((BatchTableModel)this.batchTable.getModel()).fireTableCellUpdated(batchNum, 0);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel9 = new JLabel();
        this.spinnerNumberOfRuns = new JSpinner();
        this.jLabel10 = new JLabel();
        this.tfFitnessInstance = new JTextField();
        this.buConfigFitnessFunction = new JButton();
        this.jLabel12 = new JLabel();
        this.tfPopulation = new JTextField();
        this.buConfigInitializationOperator = new JButton();
        this.jLabel1 = new JLabel();
        this.tfSearchSpace = new JTextField();
        this.buConfigSearchSpace = new JButton();
        this.jPanel6 = new JPanel();
        this.scrollBatchTable = new JScrollPane();
        this.buBatchMoveUp = new JButton();
        this.buBatchMoveDown = new JButton();
        this.jPanel2 = new JPanel();
        this.buNewBatch = new JButton();
        this.buCopyBatch = new JButton();
        this.buDeleteBatch = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Create Batches of Runs"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder("Batch properties"));
        this.jLabel9.setText("Number of Runs:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel1.add((Component)this.jLabel9, gridBagConstraints);
        this.spinnerNumberOfRuns.setMinimumSize(new Dimension(64, 24));
        this.spinnerNumberOfRuns.setPreferredSize(new Dimension(64, 24));
        this.spinnerNumberOfRuns.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.spinnerNumberOfRuns, gridBagConstraints);
        this.jLabel10.setText("Fitness Function:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel1.add((Component)this.jLabel10, gridBagConstraints);
        this.tfFitnessInstance.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.tfFitnessInstance, gridBagConstraints);
        this.buConfigFitnessFunction.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        this.buConfigFitnessFunction.setText("Configure...");
        this.buConfigFitnessFunction.setEnabled(false);
        this.buConfigFitnessFunction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelBatches.this.buConfigFitnessFunctionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel1.add((Component)this.buConfigFitnessFunction, gridBagConstraints);
        this.jLabel12.setText("Initial Population:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel12, gridBagConstraints);
        this.tfPopulation.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.tfPopulation, gridBagConstraints);
        this.buConfigInitializationOperator.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        this.buConfigInitializationOperator.setText("Configure...");
        this.buConfigInitializationOperator.setEnabled(false);
        this.buConfigInitializationOperator.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelBatches.this.buConfigInitializationOperatorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel1.add((Component)this.buConfigInitializationOperator, gridBagConstraints);
        this.jLabel1.setText("Search Space:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.tfSearchSpace.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.tfSearchSpace, gridBagConstraints);
        this.buConfigSearchSpace.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        this.buConfigSearchSpace.setText("Configure...");
        this.buConfigSearchSpace.setEnabled(false);
        this.buConfigSearchSpace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelBatches.this.buConfigSearchSpaceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel1.add((Component)this.buConfigSearchSpace, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jPanel6.setBorder(new TitledBorder("Planned batches"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.jPanel6.add((Component)this.scrollBatchTable, gridBagConstraints);
        this.buBatchMoveUp.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif")));
        this.buBatchMoveUp.setEnabled(false);
        this.buBatchMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelBatches.this.buBatchMoveUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 0.1;
        this.jPanel6.add((Component)this.buBatchMoveUp, gridBagConstraints);
        this.buBatchMoveDown.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif")));
        this.buBatchMoveDown.setEnabled(false);
        this.buBatchMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelBatches.this.buBatchMoveDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 0.1;
        this.jPanel6.add((Component)this.buBatchMoveDown, gridBagConstraints);
        this.jPanel2.setLayout(new GridLayout(1, 0, 5, 0));
        this.buNewBatch.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/New16.gif")));
        this.buNewBatch.setMnemonic('e');
        this.buNewBatch.setText("New Batch");
        this.buNewBatch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelBatches.this.buNewBatchActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.buNewBatch);
        this.buCopyBatch.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Copy16.gif")));
        this.buCopyBatch.setText("Copy Batch");
        this.buCopyBatch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelBatches.this.buCopyBatchActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.buCopyBatch);
        this.buDeleteBatch.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Delete16.gif")));
        this.buDeleteBatch.setText("Remove Batch");
        this.buDeleteBatch.setEnabled(false);
        this.buDeleteBatch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelBatches.this.buDeleteBatchActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.buDeleteBatch);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel6.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.jPanel6, gridBagConstraints);
    }

    private void buCopyBatchActionPerformed(ActionEvent evt) {
        int selectedRow = this.batchTable.getSelectedRow();
        if (selectedRow >= 0 && selectedRow < this.batchList.size()) {
            Batch selectedBatch = this.batchList.get(this.batchTable.getSelectedRow());
            Batch newBatch = selectedBatch.copy();
            this.batchTable.appendBatch(newBatch, false);
            this.batchTable.changeSelection(this.batchList.size() - 1, 0, false, false);
            this.checkBatch(this.batchList.size() - 1);
            this.scheduleEditor.updateComponents();
        }
    }

    private void buConfigSearchSpaceActionPerformed(ActionEvent evt) {
        if (!this.batchTable.getSelectionModel().isSelectionEmpty()) {
            SearchSpace ss = this.schedule.getPhenotypeSearchSpace();
            if (ss == null) {
                throw new NullPointerException("Searchspace is null. This should not be!");
            }
            if (ss instanceof Configurable) {
                this.configureBatchModule((Configurable)((Object)ss), this.batchTable.getSelectedRow());
            } else {
                JOptionPane.showMessageDialog(this, "This search space is not configurable.");
            }
        }
    }

    private void buConfigFitnessFunctionActionPerformed(ActionEvent evt) {
        if (!this.batchTable.getSelectionModel().isSelectionEmpty()) {
            FitnessFunction fitness = this.schedule.getRealFitnessFunction();
            if (fitness == null) {
                throw new NullPointerException("Fitness function is null. This should not be!");
            }
            if (fitness instanceof Configurable) {
                this.configureBatchModule((Configurable)((Object)fitness), this.batchTable.getSelectedRow());
            } else {
                JOptionPane.showMessageDialog(this, "This fitness function is not configurable.");
            }
        }
    }

    private void buConfigInitializationOperatorActionPerformed(ActionEvent evt) {
        if (!this.batchTable.getSelectionModel().isSelectionEmpty()) {
            Initialization ig = this.schedule.getInitialization();
            if (ig == null) {
                throw new NullPointerException("SCD: initialization operator is null. This should not be!");
            }
            if (ig instanceof Configurable) {
                this.configureBatchModule(ig, this.batchTable.getSelectedRow());
            } else {
                JOptionPane.showMessageDialog(this, "This initialization operator is not configurable.");
            }
        }
    }

    private void buBatchMoveDownActionPerformed(ActionEvent evt) {
        int row = this.batchTable.getSelectedRow();
        if (!this.isBatchFixed(row) && !this.isBatchFixed(row + 1)) {
            Batch batch = this.batchList.get(row);
            this.batchList.set(row, this.batchList.get(row + 1));
            this.batchList.set(row + 1, batch);
            this.batchTable.changeSelection(row + 1, 0, false, false);
        } else {
            JOptionPane.showMessageDialog(this, "Cannot exchange batch with a running or finished batch.");
        }
    }

    private void buBatchMoveUpActionPerformed(ActionEvent evt) {
        int row = this.batchTable.getSelectedRow();
        if (!this.isBatchFixed(row) && !this.isBatchFixed(row - 1)) {
            Batch batch = this.batchList.get(row);
            this.batchList.set(row, this.batchList.get(row - 1));
            this.batchList.set(row - 1, batch);
            this.batchTable.changeSelection(row - 1, 0, false, false);
        } else {
            JOptionPane.showMessageDialog(this, "Cannot exchange batch with a running or finished batch.");
        }
    }

    private void buDeleteBatchActionPerformed(ActionEvent evt) {
        if (!this.batchTable.getSelectionModel().isSelectionEmpty()) {
            int row = this.batchTable.getSelectedRow();
            if (!this.isBatchFixed(row)) {
                this.batchTable.deleteRow(row);
                this.batchTable.changeSelection(row == 0 ? 0 : row - 1, 0, false, false);
                this.scheduleEditor.updateComponents();
            } else {
                JOptionPane.showMessageDialog(this, "Cannot remove this batch.");
            }
        }
    }

    private void buNewBatchActionPerformed(ActionEvent evt) {
        Batch newBatch = this.schedule.getDefaultBatch().copy();
        this.batchTable.appendBatch(newBatch, true);
        this.batchTable.changeSelection(this.batchList.size() - 1, 0, false, false);
        this.checkBatch(this.batchList.size() - 1);
        this.scheduleEditor.updateComponents();
    }
}

