/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view;

import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.fitness.MultiObjectiveFitnessFunction;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.population.Individual;
import freak.core.view.swingsupport.FreakTitledBorderModel;
import freak.module.fitness.pointset.AbstractStaticSingleObjectiveRobustRegressionFitness;
import freak.module.observer.ResultObserver;
import freak.module.searchspace.BitStringGenotype;
import freak.module.searchspace.BooleanFunction;
import freak.module.searchspace.BooleanFunctionGenotype;
import freak.module.searchspace.logictree.DNFTree;
import freak.module.searchspace.logictree.Data;
import freak.module.view.StdView;
import freak.rinterface.model.RReturns;
import freak.rinterface.model.SAtomicCharacterVector;
import freak.rinterface.model.SAtomicDoubleVector;
import freak.rinterface.model.SAtomicIntegerVector;
import freak.rinterface.model.SDataFrame;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class RReturn
extends StdView {
    private static final long serialVersionUID = 1L;
    private SDataFrame dataFrame = new SDataFrame();
    private SAtomicCharacterVector dataSetVector = new SAtomicCharacterVector();
    private SAtomicIntegerVector runVector = new SAtomicIntegerVector();
    private SAtomicIntegerVector generationsVector = new SAtomicIntegerVector();
    private SAtomicCharacterVector individualsVector = new SAtomicCharacterVector();
    private SAtomicDoubleVector[] objectivesArray;
    private double bestValue = -1.7976931348623157E308;
    private Vector<DNFTree> allTrees = new Vector();
    private FreakTitledBorderModel borderModel = new FreakTitledBorderModel();
    private boolean recreate;

    public RReturn(Schedule schedule) {
        super(schedule);
    }

    public String getDescription() {
        return "Creates summarys of the Result Observer that are easy to read from R.";
    }

    public String getName() {
        return "R Return";
    }

    public void update(Object o) {
        int runs;
        super.update(o);
        ResultObserver.Result result = (ResultObserver.Result)o;
        FitnessFunction fitness = this.getSchedule().getFitnessFunction();
        boolean singleObjective = fitness instanceof SingleObjectiveFitnessFunction;
        int n = runs = !Data.csvDisable && result.getTestDataPath().equals("") || Data.csvDisable && Data.testData == null ? 1 : 2;
        if (result.getRunNumber() == 1) {
            if (runs == 2) {
                this.dataFrame.addColname("Data Set");
            }
            this.dataFrame.addColname("Run");
            this.dataFrame.addColname("Generation");
            if (singleObjective) {
                this.dataFrame.addColname("Objective value");
                this.objectivesArray = new SAtomicDoubleVector[1];
                this.objectivesArray[0] = new SAtomicDoubleVector();
            } else {
                int objectives = ((MultiObjectiveFitnessFunction)fitness).getDimensionOfObjectiveSpace();
                this.objectivesArray = new SAtomicDoubleVector[objectives];
                int j = 1;
                while (j <= objectives) {
                    this.dataFrame.addColname("Objective value " + j);
                    this.objectivesArray[j - 1] = new SAtomicDoubleVector();
                    ++j;
                }
            }
            this.dataFrame.addColname("Individual");
        }
        int k = 0;
        while (k < runs) {
            if (runs == 2) {
                if (k == 1) {
                    if (Data.csvDisable) {
                        Data.setRData(Data.trainingData);
                    } else {
                        Data.setDataLocation(((BooleanFunction)this.schedule.getGenotypeSearchSpace()).getPropertyInputPath());
                    }
                } else if (Data.csvDisable) {
                    Data.setRData(Data.testData);
                } else {
                    Data.setDataLocation(result.getTestDataPath());
                }
                try {
                    Data.readData();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Iterator i = result.getBestIndividuals().iterator();
            while (i.hasNext()) {
                double fitnessValue;
                Individual individual = (Individual)i.next();
                if (runs == 2 && individual.getGenotype() instanceof BooleanFunctionGenotype) {
                    individual.setLatestKnownFitnessValue(null);
                    ((BooleanFunctionGenotype)individual.getGenotype()).getDnfbaum().update();
                    if (Data.csvDisable) {
                        if (k == 1) {
                            this.dataSetVector.add("training");
                        } else {
                            this.dataSetVector.add("test");
                        }
                    } else {
                        this.dataSetVector.add(Data.getDataLocation());
                    }
                }
                this.runVector.add(result.getRunNumber());
                this.generationsVector.add(individual.getDateOfBirth());
                if (singleObjective) {
                    this.objectivesArray[0].add(((SingleObjectiveFitnessFunction)fitness).evaluate(individual, result.getBestIndividuals()));
                } else {
                    double[] results = ((MultiObjectiveFitnessFunction)fitness).evaluate(individual, result.getBestIndividuals());
                    int j = 0;
                    while (j < results.length) {
                        this.objectivesArray[j].add(results[j]);
                        ++j;
                    }
                }
                this.individualsVector.add(individual.getGenotype().toString());
                if (individual.getGenotype() instanceof BooleanFunctionGenotype) {
                    this.allTrees.add(((BooleanFunctionGenotype)individual.getGenotype()).getDnfbaum());
                }
                if (!(individual.getGenotype() instanceof BitStringGenotype) || !(fitness instanceof AbstractStaticSingleObjectiveRobustRegressionFitness) || !((fitnessValue = ((AbstractStaticSingleObjectiveRobustRegressionFitness)fitness).evaluate(individual, result.getBestIndividuals())) > this.bestValue)) continue;
                this.bestValue = fitnessValue;
                RReturns.setResidual(-fitnessValue);
                RReturns.setFittedHyperplane(((AbstractStaticSingleObjectiveRobustRegressionFitness)fitness).getFittedHyperplane());
                RReturns.setChosenIndices(((AbstractStaticSingleObjectiveRobustRegressionFitness)fitness).getChosenIndices());
            }
            ++k;
        }
        if (this.getSchedule().isLastRunInBatch()) {
            if (runs == 2) {
                this.dataFrame.add(this.dataSetVector);
            }
            this.dataFrame.add(this.runVector);
            this.dataFrame.add(this.generationsVector);
            int i = 0;
            while (i < this.objectivesArray.length) {
                this.dataFrame.add(this.objectivesArray[i]);
                ++i;
            }
            this.dataFrame.add(this.individualsVector);
            RReturns.setDataFrame(this.dataFrame);
            RReturns.setAllTrees(this.allTrees);
        }
    }

    public JPanel createPanel() {
        this.recreate = true;
        JPanel panel = super.createPanel();
        TitledBorder border = new TitledBorder("");
        panel.setBorder(border);
        this.borderModel.setView(border);
        this.borderModel.setTitle("Writing to auto-generated file");
        return panel;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public Class[] getInputDataTypes() {
        return new Class[]{ResultObserver.Result.class};
    }
}

