/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.services;

import edu.ucsb.cs.jicos.foundation.Command;
import edu.ucsb.cs.jicos.foundation.Proxy;
import edu.ucsb.cs.jicos.foundation.RemoteExceptionHandler;
import edu.ucsb.cs.jicos.foundation.Service;
import edu.ucsb.cs.jicos.foundation.ServiceName;
import edu.ucsb.cs.jicos.services.Host;
import edu.ucsb.cs.jicos.services.HostTaskStats;
import edu.ucsb.cs.jicos.services.JicosRemoteExceptionHandler;
import edu.ucsb.cs.jicos.services.SessionInfo;
import edu.ucsb.cs.jicos.services.Task;
import edu.ucsb.cs.jicos.services.TaskId;
import edu.ucsb.cs.jicos.services.TaskInfo;
import edu.ucsb.cs.jicos.services.TaskServer;
import edu.ucsb.cs.jicos.services.commands.LoginClient;
import edu.ucsb.cs.jicos.services.commands.LogoutClient;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public final class HostProxy
extends Proxy {
    private static final long TERM = 5000L;
    private static final Command LOGOUT_CLIENT;
    private static final RemoteExceptionHandler REMOTE_EXCEPTION_HANDLER;
    private TaskServer taskServer;
    private Service host;
    private Set taskIds = Collections.synchronizedSortedSet(new TreeSet());
    private HostTaskStats hostTaskStats;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$HostProxy;

    HostProxy(ServiceName serviceName, TaskServer taskServer, RemoteExceptionHandler remoteExceptionHandler) {
        super(serviceName, taskServer, remoteExceptionHandler, 5000L);
        this.host = this.serviceName().service();
        this.taskServer = taskServer;
        this.hostTaskStats = taskServer == null ? new HostTaskStats(serviceName, false) : new HostTaskStats(serviceName, true);
    }

    public void evict() {
        System.out.println("HostProxy.evict: " + this.serviceName());
        this.unregisterHost();
    }

    public synchronized void executeTask(Task task) {
        this.taskIds.add(task.getTaskId());
    }

    Service host() {
        return this.host;
    }

    HostTaskStats hostTaskStats() {
        return this.hostTaskStats;
    }

    public synchronized void loginClient(SessionInfo sessionInfo) {
        this.hostTaskStats.clear();
        if (this.taskServer == null) {
            ((Host)this.host).loginClient(sessionInfo);
        } else {
            LoginClient loginClient = new LoginClient(sessionInfo);
            this.sendCommand(loginClient);
        }
    }

    HostTaskStats logoutClient() {
        return this.hostTaskStats;
    }

    synchronized void processResult(TaskInfo taskInfo) {
        this.renew();
        this.hostTaskStats.add(taskInfo);
        TaskId taskId = taskInfo.taskId();
        this.taskIds.remove(taskId);
    }

    synchronized void unregisterHost() {
        if (!$assertionsDisabled && this.taskServer == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.taskIds == null) {
            throw new AssertionError();
        }
        Iterator iterator = this.taskIds.iterator();
        while (iterator.hasNext()) {
            TaskId taskId = (TaskId)iterator.next();
            System.out.println("HostProxy.unregisterHost: unassigning: " + taskId);
            this.taskServer.session().unassign(taskId);
            iterator.remove();
        }
        this.taskServer.unregisterHost(this.host);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$edu$ucsb$cs$jicos$services$HostProxy == null ? (class$edu$ucsb$cs$jicos$services$HostProxy = HostProxy.class$("edu.ucsb.cs.jicos.services.HostProxy")) : class$edu$ucsb$cs$jicos$services$HostProxy).desiredAssertionStatus();
        LOGOUT_CLIENT = new LogoutClient();
        REMOTE_EXCEPTION_HANDLER = new JicosRemoteExceptionHandler();
    }
}

